/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtomicInstallArtifactLifecycleListener
extends InstallArtifactLifecycleListenerSupport {
    private final Logger logger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public AtomicInstallArtifactLifecycleListener() {
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onStarting(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                this.logger.debug("Processing atomic starting event for {}", (Object)installArtifact);
                InstallArtifact atomicParent = this.getAtomicParent(installArtifact);
                if (atomicParent != null) {
                    if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                        this.logger.info("Atomic starting event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                    } else {
                        this.logger.info("Propagating atomic starting event from {} to {}", (Object)installArtifact, (Object)atomicParent);
                        atomicParent.start();
                    }
                } else {
                    this.logger.info("No atomic parent of {} to propagate starting event to", (Object)installArtifact);
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onStartFailed(InstallArtifact installArtifact, Throwable cause) throws DeploymentException {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                this.logger.debug("Processing atomic start failed (stop) event for {}", (Object)installArtifact);
                InstallArtifact atomicParent = this.getAtomicParent(installArtifact);
                if (atomicParent != null) {
                    if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                        this.logger.info("Atomic start failed event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                    } else {
                        this.logger.info("Propagating atomic start failed (stop) event from {} to {}", (Object)installArtifact, (Object)atomicParent);
                        atomicParent.stop();
                    }
                } else {
                    this.logger.info("No atomic parent of {} to propagate start failed (stop) event to", (Object)installArtifact);
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onStopped(InstallArtifact installArtifact) {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                this.logger.debug("Processing atomic stopped event for {}", (Object)installArtifact);
                InstallArtifact atomicParent = this.getAtomicParent(installArtifact);
                if (atomicParent != null) {
                    if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                        this.logger.info("Atomic stopped event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                    } else {
                        this.logger.info("Propagating atomic stopped event from {} to {}", (Object)installArtifact, (Object)atomicParent);
                        try {
                            atomicParent.stop();
                        }
                        catch (DeploymentException e) {
                            this.logger.warn("Unable to propagate stopped event to the atomic root due to an exception", (Throwable)e);
                        }
                    }
                } else {
                    this.logger.info("No atomic parent of {} to propagate stopped event to", (Object)installArtifact);
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onUninstalled(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                this.logger.debug("Processing atomic uninstalled event for {}", (Object)installArtifact);
                InstallArtifact atomicParent = this.getAtomicParent(installArtifact);
                if (atomicParent != null) {
                    if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                        this.logger.info("Atomic uninstalled event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                    } else {
                        this.logger.info("Propagating atomic uninstalled event from {} to {}", (Object)installArtifact, (Object)atomicParent);
                        atomicParent.uninstall();
                    }
                } else {
                    this.logger.info("No atomic parent of {} to propagate uninstalled event to", (Object)installArtifact);
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private InstallArtifact getAtomicParent(InstallArtifact installArtifact) {
        try {
            InstallArtifact parent = AtomicInstallArtifactLifecycleListener.getParentInstallArtifact(installArtifact);
            return AtomicInstallArtifactLifecycleListener.isAtomicInstallArtifact(parent) ? parent : null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static final boolean isAtomicInstallArtifact(InstallArtifact installArtifact) {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                boolean bl = installArtifact instanceof PlanInstallArtifact ? ((PlanInstallArtifact)installArtifact).isAtomic() : false;
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return bl;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static final InstallArtifact getParentInstallArtifact(InstallArtifact installArtifact) {
        try {
            Tree iaTree = installArtifact.getTree();
            if (iaTree != null && (iaTree = iaTree.getParent()) != null) {
                return (InstallArtifact)iaTree.getValue();
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean aChildIsRefreshing(InstallArtifact atomicParent) {
        try {
            try {
                boolean bl;
                block6: {
                    AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                    InstallArtifact[] installArtifactArray = AtomicInstallArtifactLifecycleListener.childrenOf(atomicParent);
                    int n = installArtifactArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractInstallArtifact aChild;
                        InstallArtifact child = installArtifactArray[n2];
                        if (child instanceof AbstractInstallArtifact && (aChild = (AbstractInstallArtifact)child).isRefreshing()) {
                            bl = true;
                            break block6;
                        }
                        ++n2;
                    }
                    bl = false;
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return bl;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static InstallArtifact[] childrenOf(InstallArtifact parent) {
        try {
            try {
                Tree<InstallArtifact> tree;
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                ArrayList<InstallArtifact> children = new ArrayList<InstallArtifact>();
                if (parent != null && (tree = parent.getTree()) != null) {
                    for (Tree childBranch : tree.getChildren()) {
                        InstallArtifact child = (InstallArtifact)childBranch.getValue();
                        if (child == null) continue;
                        children.add(child);
                    }
                }
                InstallArtifact[] installArtifactArray = children.toArray(new InstallArtifact[children.size()]);
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return installArtifactArray;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("AtomicInstallArtifactLifecycleListener.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onStarting", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 42);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onStartFailed", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:java.lang.Throwable:", "installArtifact:cause:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 59);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onStopped", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "", "void"), 77);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onUninstalled", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 99);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1a", "isAtomicInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "", "boolean"), 128);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "aChildIsRefreshing", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "atomicParent:", "", "boolean"), 159);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "childrenOf", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "parent:", "", "[Lorg.eclipse.virgo.kernel.install.artifact.InstallArtifact;"), 175);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener");
    }
}

