/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.phases;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.operations.ActionGenerationOperation;
import org.eclipse.viatra.examples.cps.generator.operations.DeleteTransitionWithoutAction;
import org.eclipse.viatra.examples.cps.generator.phases.CPSPhaseActionGeneration;
import org.eclipse.viatra.examples.cps.generator.queries.PossibleReceiverTypeMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.ReachableAppTypesMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.ReceiverTransitionMatch;
import org.eclipse.viatra.examples.cps.generator.queries.ReceiverTransitionMatcher;
import org.eclipse.viatra.examples.cps.generator.queries.TransitionsMatcher;
import org.eclipse.viatra.examples.cps.planexecutor.api.IOperation;
import org.eclipse.viatra.examples.cps.planexecutor.api.IPhase;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CPSPhaseActionStatisticsBasedGeneration
implements IPhase<CPSFragment> {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.generator.impl.CPSPhaseActionGeneration");
    public static String WAIT_METHOD_NAME = CPSPhaseActionGeneration.WAIT_METHOD_NAME;
    public static String SEND_METHOD_NAME = CPSPhaseActionGeneration.SEND_METHOD_NAME;

    public Iterable<IOperation<CPSFragment>> getOperations(final CPSFragment fragment) {
        try {
            final ArrayList operations = Lists.newArrayList();
            final PossibleReceiverTypeMatcher matcher = PossibleReceiverTypeMatcher.on((ViatraQueryEngine)fragment.getEngine());
            final ReceiverTransitionMatcher receiverTransitionMatcher = ReceiverTransitionMatcher.on((ViatraQueryEngine)fragment.getEngine());
            final HashSet suppliedWithAction = Sets.newHashSet();
            Procedures.Procedure2<Transition, Integer> _function = new Procedures.Procedure2<Transition, Integer>(){

                public void apply(Transition senderTransition, Integer index) {
                    Set<ApplicationType> reachableTypes = matcher.getAllValuesOfReceiverAppType(senderTransition);
                    boolean success = false;
                    for (ApplicationType type : reachableTypes) {
                        boolean _greaterEqualsThan;
                        if (success) continue;
                        Collection<ReceiverTransitionMatch> receiverMatches = receiverTransitionMatcher.getAllMatches(type, null, null);
                        Transition firstReceiver = null;
                        StateMachine firstSM = null;
                        Transition secondReceiver = null;
                        for (ReceiverTransitionMatch receiverMatch : receiverMatches) {
                            boolean _not_1;
                            boolean _equals = Objects.equal(firstReceiver, null);
                            if (_equals) {
                                boolean _not;
                                boolean _contains = suppliedWithAction.contains(receiverMatch.getTransition());
                                boolean bl = _not = !_contains;
                                if (!_not) continue;
                                firstReceiver = receiverMatch.getTransition();
                                firstSM = receiverMatch.getSM();
                                continue;
                            }
                            if (!Objects.equal(secondReceiver, null) || Objects.equal((Object)receiverMatch.getSM(), firstSM)) continue;
                            boolean _contains_1 = suppliedWithAction.contains(receiverMatch.getTransition());
                            boolean bl = _not_1 = !_contains_1;
                            if (!_not_1) continue;
                            secondReceiver = receiverMatch.getTransition();
                        }
                        if (!suppliedWithAction.contains(senderTransition) && !Objects.equal(firstReceiver, null)) {
                            boolean _notEquals;
                            success = true;
                            suppliedWithAction.add(senderTransition);
                            String _identifier = type.getIdentifier();
                            String _plus = String.valueOf(SEND_METHOD_NAME) + "(" + _identifier;
                            String _plus_1 = String.valueOf(_plus) + ", ";
                            String _plus_2 = String.valueOf(_plus_1) + index;
                            String senderAction = String.valueOf(_plus_2) + ")";
                            CPSPhaseActionStatisticsBasedGeneration.this.logger.debug((Object)senderAction);
                            ActionGenerationOperation _actionGenerationOperation = new ActionGenerationOperation(senderAction, senderTransition);
                            operations.add(_actionGenerationOperation);
                            suppliedWithAction.add(firstReceiver);
                            String receiverAction1 = String.valueOf(WAIT_METHOD_NAME) + "(" + index + ")";
                            CPSPhaseActionStatisticsBasedGeneration.this.logger.debug((Object)receiverAction1);
                            ActionGenerationOperation _actionGenerationOperation_1 = new ActionGenerationOperation(receiverAction1, firstReceiver);
                            operations.add(_actionGenerationOperation_1);
                            boolean bl = _notEquals = !Objects.equal((Object)secondReceiver, null);
                            if (_notEquals) {
                                suppliedWithAction.add(secondReceiver);
                                String receiverAction2 = String.valueOf(WAIT_METHOD_NAME) + "(" + index + ")";
                                CPSPhaseActionStatisticsBasedGeneration.this.logger.debug((Object)receiverAction2);
                                ActionGenerationOperation _actionGenerationOperation_2 = new ActionGenerationOperation(receiverAction2, secondReceiver);
                                operations.add(_actionGenerationOperation_2);
                            }
                        }
                        int _numberOfSignals = fragment.getNumberOfSignals();
                        boolean bl = _greaterEqualsThan = index >= _numberOfSignals;
                        if (!_greaterEqualsThan) continue;
                        CPSPhaseActionStatisticsBasedGeneration.this.logger.debug((Object)"#Warning: more signal was generated than it is set in fragment.numberOfSignals");
                    }
                }
            };
            IterableExtensions.forEach(matcher.getAllValuesOfSender(), (Procedures.Procedure2)_function);
            DeleteTransitionWithoutAction _deleteTransitionWithoutAction = new DeleteTransitionWithoutAction(fragment);
            operations.add(_deleteTransitionWithoutAction);
            return operations;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Set<Transition> getTransitionsOf(ApplicationType type, CPSFragment fragment) {
        try {
            return TransitionsMatcher.on((ViatraQueryEngine)fragment.getEngine()).getAllValuesOft(type.getBehavior());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Set<ApplicationType> getPossibleAppTypesOf(ApplicationType type, CPSFragment fragment) {
        try {
            return ReachableAppTypesMatcher.on((ViatraQueryEngine)fragment.getEngine()).getAllValuesOfTo(type);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

