/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperDescriptor;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperManager;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.navigator.INavigatorContentService;

public class LinkHelperService {
    private static final ILinkHelper[] CANT_GET_NO_HELP = new ILinkHelper[0];
    private NavigatorContentService contentService;
    private final Map linkHelpers = new HashMap();

    LinkHelperService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public ILinkHelper[] getLinkHelpersFor(Object anObject) {
        LinkHelperDescriptor[] descriptors = LinkHelperManager.getInstance().getLinkHelpersFor(anObject, (INavigatorContentService)this.contentService);
        if (descriptors.length == 0) {
            return CANT_GET_NO_HELP;
        }
        LinkedHashSet<ILinkHelper> helpers = new LinkedHashSet<ILinkHelper>();
        LinkHelperDescriptor[] linkHelperDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            LinkHelperDescriptor descriptor = linkHelperDescriptorArray[n2];
            helpers.add(this.getLinkHelper(descriptor));
            ++n2;
        }
        if (helpers.size() == 0) {
            return CANT_GET_NO_HELP;
        }
        return helpers.toArray(new ILinkHelper[helpers.size()]);
    }

    public ILinkHelper[] getLinkHelpersFor(IEditorInput input) {
        LinkHelperDescriptor[] descriptors = LinkHelperManager.getInstance().getLinkHelpersFor(input, (INavigatorContentService)this.contentService);
        if (descriptors.length == 0) {
            return CANT_GET_NO_HELP;
        }
        LinkedHashSet<ILinkHelper> helpers = new LinkedHashSet<ILinkHelper>();
        LinkHelperDescriptor[] linkHelperDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            LinkHelperDescriptor descriptor = linkHelperDescriptorArray[n2];
            helpers.add(this.getLinkHelper(descriptor));
            ++n2;
        }
        if (helpers.size() == 0) {
            return CANT_GET_NO_HELP;
        }
        return helpers.toArray(new ILinkHelper[helpers.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILinkHelper getLinkHelper(LinkHelperDescriptor descriptor) {
        ILinkHelper helper = (ILinkHelper)this.linkHelpers.get(descriptor);
        if (helper == null) {
            LinkHelperService linkHelperService = this;
            synchronized (linkHelperService) {
                if (helper == null) {
                    helper = descriptor.createLinkHelper();
                    this.linkHelpers.put(descriptor, helper);
                }
            }
        }
        return helper;
    }

    public IStructuredSelection getSelectionFor(IEditorInput input) {
        ILinkHelper[] helpers = this.getLinkHelpersFor(input);
        StructuredSelection selection = StructuredSelection.EMPTY;
        StructuredSelection newSelection = StructuredSelection.EMPTY;
        ILinkHelper[] iLinkHelperArray = helpers;
        int n = helpers.length;
        int n2 = 0;
        while (n2 < n) {
            ILinkHelper helper = iLinkHelperArray[n2];
            selection = helper.findSelection(input);
            if (selection != null && !selection.isEmpty()) {
                newSelection = this.mergeSelection((IStructuredSelection)newSelection, (IStructuredSelection)selection);
            }
            ++n2;
        }
        return newSelection;
    }

    private IStructuredSelection mergeSelection(IStructuredSelection aBase, IStructuredSelection aSelectionToAppend) {
        if (aBase == null || aBase.isEmpty()) {
            return aSelectionToAppend != null ? aSelectionToAppend : StructuredSelection.EMPTY;
        }
        if (aSelectionToAppend == null || aSelectionToAppend.isEmpty()) {
            return aBase;
        }
        ArrayList newItems = new ArrayList(aBase.toList());
        newItems.addAll(aSelectionToAppend.toList());
        return new StructuredSelection(newItems);
    }
}

