/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.markers;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.IDE;

public class MarkerInformationControl
extends AbstractInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2 {
    private IInformationControlCreator creator;
    private Collection<IMarker> markers;
    private Composite parent;

    public MarkerInformationControl(Shell parentShell, IInformationControlCreator creator) {
        super(parentShell, EditorsUI.getTooltipAffordanceString());
        this.creator = creator;
        this.create();
    }

    public boolean hasContents() {
        return this.markers != null && !this.markers.isEmpty();
    }

    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        parent.setLayoutData((Object)new GridData(4, 4, false, false));
        parent.setBackgroundMode(1);
        this.parent = parent;
    }

    private static Image getImage(IMarker marker) {
        switch (marker.getAttribute("severity", -1)) {
            case 2: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            case 1: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            case 0: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }

    public void setInput(Object input) {
        this.markers = (List)input;
        for (final IMarker marker : this.markers) {
            Composite markerComposite = new Composite(this.parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.verticalSpacing = 0;
            markerComposite.setLayout((Layout)gridLayout);
            Composite markerLine = new Composite(markerComposite, 0);
            markerLine.setLayout((Layout)new RowLayout());
            Label markerImage = new Label(markerLine, 0);
            markerImage.setImage(MarkerInformationControl.getImage(marker));
            Label markerLabel = new Label(markerLine, 0);
            markerLabel.setText(marker.getAttribute("message", "missing message"));
            IMarkerResolution[] iMarkerResolutionArray = IDE.getMarkerHelpRegistry().getResolutions(marker);
            int n = iMarkerResolutionArray.length;
            int n2 = 0;
            while (n2 < n) {
                final IMarkerResolution resolution = iMarkerResolutionArray[n2];
                Composite resolutionComposite = new Composite(markerComposite, 0);
                GridData layoutData = new GridData();
                layoutData.horizontalIndent = 10;
                resolutionComposite.setLayoutData((Object)layoutData);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginBottom = 0;
                resolutionComposite.setLayout((Layout)rowLayout);
                Label resolutionImage = new Label(resolutionComposite, 0);
                Image resolutionPic = null;
                if (resolution instanceof IMarkerResolution2) {
                    resolutionPic = ((IMarkerResolution2)resolution).getImage();
                }
                if (resolutionPic == null) {
                    resolutionPic = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OPEN_MARKER");
                }
                resolutionImage.setImage(resolutionPic);
                Link resolutionLink = new Link(resolutionComposite, 0);
                resolutionLink.setText("<A>" + resolution.getLabel() + "</a>");
                resolutionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Job resolutionJob = new Job("apply resolution - " + resolution.getLabel()){

                            protected IStatus run(IProgressMonitor monitor) {
                                resolution.run(marker);
                                return Status.OK_STATUS;
                            }
                        };
                        resolutionJob.setUser(true);
                        resolutionJob.setSystem(true);
                        resolutionJob.setPriority(10);
                        resolutionJob.schedule();
                        MarkerInformationControl.this.getShell().dispose();
                    }
                });
                ++n2;
            }
        }
        this.parent.pack(true);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return MarkerInformationControl.this.creator.createInformationControl(parent);
            }
        };
    }

    public Point computeSizeHint() {
        this.getShell().pack();
        return this.getShell().getSize();
    }
}

