/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.ExecutionEnvironmentDescription;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.pde.api.tools.internal.AnyValue;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.model.WorkspaceBaseline;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ApiBaseline
extends ApiElement
implements IApiBaseline,
IVMInstallChangedListener {
    private static final IApiComponent[] EMPTY_COMPONENTS = new IApiComponent[0];
    private State fState;
    private String fExecutionEnvironment;
    private IApiComponent fSystemLibraryComponent;
    private boolean fAutoResolve = true;
    private String fLocation;
    private IStatus fEEStatus = null;
    private AnyValue ANY_VALUE = new AnyValue("*");
    private HashMap<String, HashMap<IApiComponent, IApiComponent[]>> fComponentsProvidingPackageCache = null;
    private HashMap<String, IApiComponent> fComponentsById = null;
    private HashMap<String, Set<IApiComponent>> fAllComponentsById = null;
    private HashMap<String, IApiComponent> fComponentsByProjectNames = null;
    private HashSet<String> fSystemPackageNames = null;
    private IVMInstall fVMBinding = null;

    public ApiBaseline(String name) {
        super(null, 4, name);
        this.fEEStatus = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiBaseline_0);
    }

    public ApiBaseline(String name, File eeDescription) throws CoreException {
        this(name, eeDescription, null);
    }

    public ApiBaseline(String name, File eeDescription, String location) throws CoreException {
        this(name);
        if (eeDescription != null) {
            this.fAutoResolve = false;
            ExecutionEnvironmentDescription ee = new ExecutionEnvironmentDescription(eeDescription);
            String profile = ee.getProperty("-Dee.class.library.level");
            this.initialize(ee);
            this.fEEStatus = new Status(0, "org.eclipse.pde.api.tools", MessageFormat.format((String)CoreMessages.ApiBaseline_1, (Object[])new Object[]{profile}));
        }
        this.fLocation = location;
    }

    private void initialize(ExecutionEnvironmentDescription ee) throws CoreException {
        Properties properties = null;
        String environmentId = ee.getProperty("-Dee.class.library.level");
        properties = ApiPlugin.isRunningInFramework() ? ApiBaseline.getJavaProfileProperties(environmentId) : Util.getEEProfile(environmentId);
        if (properties == null) {
            this.abort("Unknown execution environment: " + environmentId, null);
        } else {
            this.initialize(properties, ee);
        }
    }

    public static Properties getJavaProfileProperties(String ee) {
        Bundle osgiBundle = Platform.getBundle((String)"org.eclipse.osgi");
        if (osgiBundle == null) {
            return null;
        }
        URL profileURL = osgiBundle.getEntry(String.valueOf(ee.replace('/', '_')) + ".profile");
        if (profileURL != null) {
            InputStream is = null;
            try {
                profileURL = FileLocator.resolve((URL)profileURL);
                URLConnection openConnection = profileURL.openConnection();
                openConnection.setUseCaches(false);
                is = openConnection.getInputStream();
                if (is != null) {
                    Properties profile = new Properties();
                    profile.load(is);
                    Properties properties = profile;
                    return properties;
                }
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    private void initialize(Properties profile, ExecutionEnvironmentDescription description) throws CoreException {
        String value = profile.getProperty("org.osgi.framework.system.packages");
        String[] systemPackages = null;
        if (value != null) {
            systemPackages = value.split(",");
        }
        if (!(this instanceof WorkspaceBaseline)) {
            Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
            ((Dictionary)dictionary).put("org.osgi.framework.system.packages", value);
            value = profile.getProperty("org.osgi.framework.executionenvironment");
            if (value != null) {
                ((Dictionary)dictionary).put("org.osgi.framework.executionenvironment", value);
            }
            this.fExecutionEnvironment = profile.getProperty("osgi.java.profile.name");
            if (this.fExecutionEnvironment == null) {
                this.abort("Profile file missing 'osgi.java.profile.name'", null);
            }
            ((Dictionary)dictionary).put("osgi.os", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.arch", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.ws", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.nl", this.ANY_VALUE);
            this.getState().setPlatformProperties(dictionary);
        }
        if (this.fSystemLibraryComponent != null && this.fComponentsById != null) {
            this.fComponentsById.remove(this.fSystemLibraryComponent.getSymbolicName());
        }
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
            this.fSystemPackageNames = null;
        }
        this.clearComponentsCache();
        this.fSystemLibraryComponent = new SystemLibraryApiComponent(this, description, systemPackages);
        this.addComponent(this.fSystemLibraryComponent);
    }

    private synchronized void clearComponentsCache() {
        if (this.fComponentsProvidingPackageCache != null) {
            this.fComponentsProvidingPackageCache.clear();
            this.fComponentsProvidingPackageCache = null;
        }
    }

    protected void addComponent(IApiComponent component) {
        IApiComponent comp;
        if (component == null) {
            return;
        }
        if (this.fComponentsById == null) {
            this.fComponentsById = new HashMap();
        }
        if (this.fAllComponentsById == null) {
            this.fAllComponentsById = new HashMap();
        }
        if ((comp = this.fComponentsById.get(component.getSymbolicName())) != null) {
            Set<IApiComponent> allComponents;
            if (this.fAllComponentsById.containsKey(component.getSymbolicName())) {
                allComponents = this.fAllComponentsById.get(component.getSymbolicName());
                if (!allComponents.contains(component)) {
                    allComponents.add(component);
                }
            } else {
                allComponents = new TreeSet<IApiComponent>(new Comparator<IApiComponent>(){

                    @Override
                    public int compare(IApiComponent comp1, IApiComponent comp2) {
                        return new Version(comp2.getVersion()).compareTo(new Version(comp1.getVersion()));
                    }
                });
                ((TreeSet)allComponents).add(comp);
                ((TreeSet)allComponents).add(component);
                this.fAllComponentsById.put(component.getSymbolicName(), allComponents);
            }
        }
        this.fComponentsById.put(component.getSymbolicName(), component);
        if (component instanceof ProjectComponent) {
            ProjectComponent projectApiComponent = (ProjectComponent)component;
            if (this.fComponentsByProjectNames == null) {
                this.fComponentsByProjectNames = new HashMap();
            }
            this.fComponentsByProjectNames.put(projectApiComponent.getJavaProject().getProject().getName(), component);
        }
    }

    @Override
    public void addApiComponents(IApiComponent[] components) throws CoreException {
        HashSet<String> ees = new HashSet<String>();
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent apiComponent = iApiComponentArray[n2];
            BundleComponent component = (BundleComponent)apiComponent;
            if (!component.isSourceComponent()) {
                BundleDescription description = component.getBundleDescription();
                this.getState().addBundle(description);
                this.addComponent(component);
                ees.addAll(Arrays.asList(component.getExecutionEnvironments()));
            }
            ++n2;
        }
        this.resolveSystemLibrary(ees);
        this.getState().resolve();
    }

    /*
     * WARNING - void declaration
     */
    protected void resolveSystemLibrary(HashSet<String> ees) {
        if (ApiPlugin.isRunningInFramework() && this.fAutoResolve) {
            void var7_15;
            int n;
            int n2;
            Object object;
            Status error = null;
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            HashMap<IVMInstall, HashSet<String>> VMsToEEs = new HashMap<IVMInstall, HashSet<String>>();
            for (String ee : ees) {
                IExecutionEnvironment iExecutionEnvironment = manager.getEnvironment(ee);
                if (iExecutionEnvironment == null) continue;
                IVMInstall[] compatibleVMs = iExecutionEnvironment.getCompatibleVMs();
                object = compatibleVMs;
                n2 = compatibleVMs.length;
                n = 0;
                while (n < n2) {
                    IVMInstall vm = object[n];
                    HashSet<String> EEs = (HashSet<String>)VMsToEEs.get(vm);
                    if (EEs == null) {
                        EEs = new HashSet<String>();
                        VMsToEEs.put(vm, EEs);
                    }
                    EEs.add(ee);
                    ++n;
                }
            }
            IVMInstall bestFit = null;
            int bestCount = 0;
            for (Map.Entry entry : VMsToEEs.entrySet()) {
                Set EEs = (Set)entry.getValue();
                if (EEs.size() <= bestCount) continue;
                bestCount = EEs.size();
                bestFit = (IVMInstall)entry.getKey();
            }
            Object var7_11 = null;
            if (bestFit != null) {
                void var7_13;
                IExecutionEnvironment[] environments = manager.getExecutionEnvironments();
                object = environments;
                n2 = environments.length;
                n = 0;
                while (n < n2) {
                    IVMInstall environment = object[n];
                    if (environment.isStrictlyCompatible(bestFit)) {
                        String string = environment.getId();
                        break;
                    }
                    ++n;
                }
                if (var7_13 == null) {
                    String string = "JavaSE-1.7";
                }
                if (!var7_15.equals(this.getExecutionEnvironment()) || this.fVMBinding == null) {
                    try {
                        File file = Util.createEEFile(bestFit, (String)var7_15);
                        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
                        this.fVMBinding = bestFit;
                        ExecutionEnvironmentDescription ee = new ExecutionEnvironmentDescription(file);
                        this.initialize(ee);
                    }
                    catch (CoreException e) {
                        error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiBaseline_2, (Throwable)e);
                    }
                    catch (IOException e) {
                        error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiBaseline_2, (Throwable)e);
                    }
                }
            } else {
                error = new Status(4, "org.eclipse.pde.api.tools", CoreMessages.ApiBaseline_6);
            }
            if (error == null) {
                HashSet<String> missing = new HashSet<String>(ees);
                HashSet covered = new HashSet((Collection)VMsToEEs.get(bestFit));
                missing.removeAll(covered);
                if (missing.isEmpty()) {
                    this.fEEStatus = new Status(0, "org.eclipse.pde.api.tools", MessageFormat.format((String)CoreMessages.ApiBaseline_1, (Object[])new Object[]{var7_15}));
                } else {
                    MultiStatus multi = new MultiStatus("org.eclipse.pde.api.tools", 0, CoreMessages.ApiBaseline_4, null);
                    for (String id : missing) {
                        multi.add((IStatus)new Status(2, "org.eclipse.pde.api.tools", MessageFormat.format((String)CoreMessages.ApiBaseline_5, (Object[])new Object[]{id})));
                    }
                    this.fEEStatus = multi;
                }
            } else {
                this.fEEStatus = error;
            }
        }
    }

    public boolean peekInfos() {
        return this.fComponentsById != null;
    }

    @Override
    public IApiComponent[] getApiComponents() {
        this.loadBaselineInfos();
        if (this.fComponentsById == null) {
            return EMPTY_COMPONENTS;
        }
        Collection<IApiComponent> values = this.fComponentsById.values();
        return values.toArray(new IApiComponent[values.size()]);
    }

    @Override
    public synchronized IApiComponent[] resolvePackage(IApiComponent sourceComponent, String packageName) throws CoreException {
        HashMap<IApiComponent, Object> componentsForPackage = null;
        if (this.fComponentsProvidingPackageCache != null) {
            componentsForPackage = this.fComponentsProvidingPackageCache.get(packageName);
        } else {
            this.fComponentsProvidingPackageCache = new HashMap(8);
        }
        IApiComponent[] cachedComponents = null;
        if (componentsForPackage != null) {
            cachedComponents = componentsForPackage.get(sourceComponent);
            if (cachedComponents != null && cachedComponents.length > 0) {
                return cachedComponents;
            }
        } else {
            componentsForPackage = new HashMap(8);
            this.fComponentsProvidingPackageCache.put(packageName, componentsForPackage);
        }
        if (sourceComponent != null) {
            ArrayList<IApiComponent> componentsList = new ArrayList<IApiComponent>();
            this.resolvePackage0(sourceComponent, packageName, componentsList);
            if (componentsList.size() != 0) {
                cachedComponents = new IApiComponent[componentsList.size()];
                componentsList.toArray(cachedComponents);
            }
        }
        if (this.isSystemPackage(packageName) && this.fSystemLibraryComponent != null) {
            if (cachedComponents == null) {
                cachedComponents = new IApiComponent[]{this.fSystemLibraryComponent};
            } else {
                IApiComponent[] cachedComponents2 = new IApiComponent[cachedComponents.length + 1];
                System.arraycopy(cachedComponents, 0, cachedComponents2, 0, cachedComponents.length);
                cachedComponents2[cachedComponents.length] = this.fSystemLibraryComponent;
                cachedComponents = cachedComponents2;
            }
        }
        if (cachedComponents == null) {
            cachedComponents = EMPTY_COMPONENTS;
        }
        if (cachedComponents.length == 0) {
            return EMPTY_COMPONENTS;
        }
        componentsForPackage.put(sourceComponent, cachedComponents);
        return cachedComponents;
    }

    private void resolvePackage0(IApiComponent component, String packageName, List<IApiComponent> componentsList) throws CoreException {
        BundleDescription bundle;
        if (component instanceof BundleComponent && (bundle = ((BundleComponent)component).getBundleDescription()) != null) {
            String[] packageNames;
            int index;
            ExportPackageDescription[] visiblePackages;
            StateHelper helper = this.getState().getStateHelper();
            ExportPackageDescription[] exportPackageDescriptionArray = visiblePackages = helper.getVisiblePackages(bundle);
            int n = visiblePackages.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundleDescription;
                IApiComponent exporter;
                ExportPackageDescription pkg = exportPackageDescriptionArray[n2];
                String pkgName = pkg.getName();
                if (pkgName.equals(".")) {
                    pkgName = "";
                }
                if (packageName.equals(pkgName) && (exporter = this.getApiComponent((bundleDescription = pkg.getExporter()).getSymbolicName())) != null) {
                    componentsList.add(exporter);
                }
                ++n2;
            }
            if (component.isFragment()) {
                BundleDescription[] hosts;
                HostSpecification host = bundle.getHost();
                BundleDescription[] bundleDescriptionArray = hosts = host.getHosts();
                int n3 = hosts.length;
                int n4 = 0;
                while (n4 < n3) {
                    BundleDescription currentHost = bundleDescriptionArray[n4];
                    IApiComponent apiComponent = component.getBaseline().getApiComponent(currentHost.getName());
                    if (apiComponent != null) {
                        this.resolvePackage0(apiComponent, packageName, componentsList);
                    }
                    ++n4;
                }
            }
            if ((index = Arrays.binarySearch(packageNames = component.getPackageNames(), packageName, null)) >= 0) {
                componentsList.add(component);
            }
        }
    }

    public IApiComponent[] getVisibleDependentComponents(IApiComponent[] components) throws CoreException {
        ArrayList<BundleDescription> bundles = this.getBundleDescriptions(components);
        BundleDescription[] descs = this.getState().getStateHelper().getDependentBundles(bundles.toArray(new BundleDescription[bundles.size()]));
        HashSet<BundleDescription> visible = new HashSet<BundleDescription>();
        ExportPackageDescription[] packages = null;
        BundleDescription[] bundleDescriptionArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription desc = bundleDescriptionArray[n2];
            ExportPackageDescription[] exportPackageDescriptionArray = packages = this.getState().getStateHelper().getVisiblePackages(desc);
            int n3 = packages.length;
            int n4 = 0;
            while (n4 < n3) {
                ExportPackageDescription package1 = exportPackageDescriptionArray[n4];
                if (bundles.contains(package1.getSupplier())) {
                    visible.add(desc);
                }
                ++n4;
            }
            ++n2;
        }
        return this.getApiComponents(visible.toArray(new BundleDescription[visible.size()]));
    }

    private boolean isSystemPackage(String packageName) {
        if (packageName.startsWith("java.")) {
            return true;
        }
        if (this.fSystemPackageNames == null) {
            ExportPackageDescription[] systemPackages = this.getState().getSystemPackages();
            this.fSystemPackageNames = new HashSet(systemPackages.length);
            ExportPackageDescription[] exportPackageDescriptionArray = systemPackages;
            int n = systemPackages.length;
            int n2 = 0;
            while (n2 < n) {
                ExportPackageDescription systemPackage = exportPackageDescriptionArray[n2];
                this.fSystemPackageNames.add(systemPackage.getName());
                ++n2;
            }
        }
        return this.fSystemPackageNames.contains(packageName);
    }

    public State getState() {
        if (this.fState == null) {
            this.fState = StateObjectFactory.defaultFactory.createState(true);
        }
        return this.fState;
    }

    @Override
    public IApiComponent getApiComponent(String id) {
        this.loadBaselineInfos();
        if (this.fComponentsById == null) {
            return null;
        }
        return this.fComponentsById.get(id);
    }

    @Override
    public Set<IApiComponent> getAllApiComponents(String id) {
        this.loadBaselineInfos();
        if (this.fAllComponentsById == null) {
            return Collections.emptySet();
        }
        if (this.fAllComponentsById.get(id) == null) {
            return Collections.emptySet();
        }
        return this.fAllComponentsById.get(id);
    }

    @Override
    public String getExecutionEnvironment() {
        return this.fExecutionEnvironment;
    }

    private void loadBaselineInfos() {
        if (this.fComponentsById != null) {
            return;
        }
        try {
            ApiBaselineManager.getManager().loadBaselineInfos(this);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
    }

    public ResolverError[] getErrors() {
        BundleDescription[] bundles;
        ArrayList<ResolverError> errs = null;
        BundleDescription[] bundleDescriptionArray = bundles = this.getState().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverError[] errors;
            BundleDescription bundle = bundleDescriptionArray[n2];
            ResolverError[] resolverErrorArray = errors = this.getState().getResolverErrors(bundle);
            int n3 = errors.length;
            int n4 = 0;
            while (n4 < n3) {
                ResolverError error = resolverErrorArray[n4];
                if (errs == null) {
                    errs = new ArrayList<ResolverError>();
                }
                errs.add(error);
                ++n4;
            }
            ++n2;
        }
        if (errs != null) {
            return errs.toArray(new ResolverError[errs.size()]);
        }
        return null;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiBaseline) {
            IApiBaseline baseline = (IApiBaseline)obj;
            return this.getName().equals(baseline.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void dispose() {
        if (this.fState == null) {
            return;
        }
        this.doDispose();
        this.fState = null;
    }

    protected void doDispose() {
        IApiComponent[] components;
        if (ApiPlugin.isRunningInFramework()) {
            JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
        }
        this.clearCachedElements();
        IApiComponent[] iApiComponentArray = components = this.getApiComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component2 = iApiComponentArray[n2];
            component2.dispose();
            ++n2;
        }
        this.clearComponentsCache();
        if (this.fComponentsById != null) {
            this.fComponentsById.clear();
            this.fComponentsById = null;
        }
        if (this.fAllComponentsById != null) {
            this.fAllComponentsById.clear();
            this.fAllComponentsById = null;
        }
        if (this.fComponentsByProjectNames != null) {
            this.fComponentsByProjectNames.clear();
            this.fComponentsByProjectNames = null;
        }
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
        }
        if (this.fSystemLibraryComponent != null) {
            this.fSystemLibraryComponent.dispose();
            this.fSystemLibraryComponent = null;
        }
    }

    @Override
    public void close() throws CoreException {
        IApiComponent[] components;
        this.clearCachedElements();
        IApiComponent[] iApiComponentArray = components = this.getApiComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component2 = iApiComponentArray[n2];
            component2.close();
            ++n2;
        }
    }

    void clearCachedElements() {
        ApiModelCache.getCache().removeElementInfo(this);
    }

    @Override
    public IApiComponent[] getDependentComponents(IApiComponent[] components) throws CoreException {
        ArrayList<BundleDescription> bundles = this.getBundleDescriptions(components);
        BundleDescription[] bundleDescriptions = this.getState().getStateHelper().getDependentBundles(bundles.toArray(new BundleDescription[bundles.size()]));
        return this.getApiComponents(bundleDescriptions);
    }

    private IApiComponent[] getApiComponents(BundleDescription[] bundles) {
        ArrayList<IApiComponent> dependents = new ArrayList<IApiComponent>(bundles.length);
        BundleDescription[] bundleDescriptionArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bundle = bundleDescriptionArray[n2];
            IApiComponent component = this.getApiComponent(bundle.getSymbolicName());
            if (component != null) {
                dependents.add(component);
            }
            ++n2;
        }
        return dependents.toArray(new IApiComponent[dependents.size()]);
    }

    private ArrayList<BundleDescription> getBundleDescriptions(IApiComponent[] components) throws CoreException {
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>(components.length);
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component = iApiComponentArray[n2];
            if (component instanceof BundleComponent) {
                bundles.add(((BundleComponent)component).getBundleDescription());
            }
            ++n2;
        }
        return bundles;
    }

    @Override
    public IApiComponent[] getPrerequisiteComponents(IApiComponent[] components) throws CoreException {
        ArrayList<BundleDescription> bundles = this.getBundleDescriptions(components);
        BundleDescription[] bundlesDescriptions = this.getState().getStateHelper().getPrerequisites(bundles.toArray(new BundleDescription[bundles.size()]));
        return this.getApiComponents(bundlesDescriptions);
    }

    public synchronized void clearPackage(String packageName) {
        if (this.fComponentsProvidingPackageCache != null) {
            this.fComponentsProvidingPackageCache.remove(packageName);
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public IStatus getExecutionEnvironmentStatus() {
        return this.fEEStatus;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
    }

    public void vmAdded(IVMInstall vm) {
        if (!(vm instanceof VMStandin)) {
            try {
                this.rebindVM();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
        String property;
        if (!(event.getSource() instanceof VMStandin) && (IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION.equals(property = event.getProperty()) || IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS.equals(property))) {
            try {
                this.rebindVM();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    private void rebindVM() throws CoreException {
        this.fVMBinding = null;
        IApiComponent[] components = this.getApiComponents();
        HashSet<String> ees = new HashSet<String>();
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component2 = iApiComponentArray[n2];
            ees.addAll(Arrays.asList(component2.getExecutionEnvironments()));
            ++n2;
        }
        this.resolveSystemLibrary(ees);
    }

    public void vmRemoved(IVMInstall vm) {
        if (vm.equals(this.fVMBinding)) {
            try {
                this.rebindVM();
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    @Override
    public String getLocation() {
        return this.fLocation;
    }

    @Override
    public void setLocation(String location) {
        this.fLocation = location;
    }

    @Override
    public IApiComponent getApiComponent(IProject project) {
        this.loadBaselineInfos();
        if (this.fComponentsByProjectNames == null) {
            return null;
        }
        return this.fComponentsByProjectNames.get(project.getName());
    }
}

