/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.InstanceListener;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperImpl;
import org.eclipse.viatra.query.runtime.base.exception.ViatraBaseException;

public class EMFBaseIndexMetaStore {
    private static final EClass EOBJECT_CLASS = EcorePackage.eINSTANCE.getEObject();
    private final boolean isDynamicModel;
    private NavigationHelperImpl navigationHelper;
    private final Set<EPackage> knownPackages = new HashSet<EPackage>();
    private final Set<EClassifier> knownClassifiers = new HashSet<EClassifier>();
    private final Set<EStructuralFeature> knownFeatures = new HashSet<EStructuralFeature>();
    private final Map<Object, Set<Object>> subTypeMap = new HashMap<Object, Set<Object>>();
    private final Map<Object, Set<Object>> superTypeMap = new HashMap<Object, Set<Object>>();
    private final Multimap<String, EPackage> uniqueIDToPackage = HashMultimap.create();
    private final Map<EClassifier, String> uniqueIDFromClassifier = new HashMap<EClassifier, String>();
    private final Map<ETypedElement, String> uniqueIDFromTypedElement = new HashMap<ETypedElement, String>();
    private final Map<Enumerator, String> uniqueIDFromEnumerator = new HashMap<Enumerator, String>();
    private final Multimap<String, EClassifier> uniqueIDToClassifier = HashMultimap.create((int)100, (int)1);
    private final Multimap<String, ETypedElement> uniqueIDToTypedElement = HashMultimap.create((int)100, (int)1);
    private final Multimap<String, Enumerator> uniqueIDToEnumerator = HashMultimap.create((int)100, (int)1);
    private final Map<String, Enumerator> uniqueIDToCanonicalEnumerator = new HashMap<String, Enumerator>();
    Map<Class<?>, EEnum> generatedEENumClasses = new HashMap();
    private Object eObjectClassKey = null;

    public EMFBaseIndexMetaStore(NavigationHelperImpl navigationHelper) {
        this.navigationHelper = navigationHelper;
        BaseIndexOptions options = navigationHelper.getBaseIndexOptions();
        this.isDynamicModel = options.isDynamicEMFMode();
    }

    public Object getEObjectClassKey() {
        if (this.eObjectClassKey == null) {
            this.eObjectClassKey = this.toKey((EClassifier)EOBJECT_CLASS);
        }
        return this.eObjectClassKey;
    }

    protected Object toKey(EClassifier classifier) {
        if (this.isDynamicModel) {
            return this.toKeyDynamicInternal(classifier);
        }
        this.maintainMetamodel(classifier);
        return classifier;
    }

    private String toKeyDynamicInternal(EClassifier classifier) {
        String id = this.uniqueIDFromClassifier.get(classifier);
        if (id == null) {
            Preconditions.checkArgument((!classifier.eIsProxy() ? 1 : 0) != 0, (String)"Classifier %s is an unresolved proxy", (Object[])new Object[]{classifier});
            id = String.valueOf(classifier.getEPackage().getNsURI()) + "##" + classifier.getName();
            this.uniqueIDFromClassifier.put(classifier, id);
            this.uniqueIDToClassifier.put((Object)id, (Object)classifier);
            this.maintainMetamodel(classifier);
        }
        return id;
    }

    private String enumToKeyDynamicInternal(Enumerator enumerator) {
        String id = this.uniqueIDFromEnumerator.get(enumerator);
        if (id == null) {
            if (enumerator instanceof EEnumLiteral) {
                EEnumLiteral enumLiteral = (EEnumLiteral)enumerator;
                EEnum eEnum = enumLiteral.getEEnum();
                this.maintainMetamodel((EClassifier)eEnum);
                id = this.constructEnumID(eEnum.getEPackage().getNsURI(), eEnum.getName(), enumLiteral.getLiteral());
                Enumerator instanceEnum = enumLiteral.getInstance();
                if (instanceEnum != null && !this.uniqueIDToCanonicalEnumerator.containsKey(id)) {
                    this.uniqueIDToCanonicalEnumerator.put(id, instanceEnum);
                }
            } else {
                EEnum eEnum = this.generatedEENumClasses.get(enumerator.getClass());
                id = eEnum != null ? this.constructEnumID(eEnum.getEPackage().getNsURI(), eEnum.getName(), enumerator.getLiteral()) : this.constructEnumID("unkownPackage URI", enumerator.getClass().getSimpleName(), enumerator.getLiteral());
                if (!this.uniqueIDToCanonicalEnumerator.containsKey(id)) {
                    this.uniqueIDToCanonicalEnumerator.put(id, enumerator);
                }
            }
            this.uniqueIDFromEnumerator.put(enumerator, id);
            this.uniqueIDToEnumerator.put((Object)id, (Object)enumerator);
        }
        return id;
    }

    private String constructEnumID(String nsURI, String name, String literal) {
        return String.format("%s##%s##%s", nsURI, name, literal);
    }

    protected Object toKey(EStructuralFeature feature) {
        if (this.isDynamicModel) {
            String id = this.uniqueIDFromTypedElement.get(feature);
            if (id == null) {
                Preconditions.checkArgument((!feature.eIsProxy() ? 1 : 0) != 0, (String)"Element %s is an unresolved proxy", (Object[])new Object[]{feature});
                id = String.valueOf(this.toKeyDynamicInternal((EClassifier)feature.eContainer())) + "##" + feature.getEType().getName() + "##" + feature.getName();
                this.uniqueIDFromTypedElement.put((ETypedElement)feature, id);
                this.uniqueIDToTypedElement.put((Object)id, (Object)feature);
                this.maintainMetamodel(feature);
            }
            return id;
        }
        this.maintainMetamodel(feature);
        return feature;
    }

    private Enumerator enumToCanonicalDynamicInternal(Enumerator value) {
        String key = this.enumToKeyDynamicInternal(value);
        Enumerator canonicalEnumerator = this.uniqueIDToCanonicalEnumerator.get(key);
        if (canonicalEnumerator == null) {
            canonicalEnumerator = (Enumerator)this.uniqueIDToEnumerator.get((Object)key).iterator().next();
            this.uniqueIDToCanonicalEnumerator.put(key, canonicalEnumerator);
        }
        return canonicalEnumerator;
    }

    protected Object toInternalValueRepresentation(Object value) {
        if (this.isDynamicModel) {
            if (value instanceof Enumerator) {
                return this.enumToCanonicalDynamicInternal((Enumerator)value);
            }
            return value;
        }
        return value;
    }

    protected void maintainMetamodel(EStructuralFeature feature) {
        if (!this.knownFeatures.contains(feature)) {
            this.knownFeatures.add(feature);
            this.maintainMetamodel((EClassifier)feature.getEContainingClass());
            this.maintainMetamodel(feature.getEType());
        }
    }

    protected void maintainMetamodel(EClassifier classifier) {
        if (!this.knownClassifiers.contains(classifier)) {
            this.checkEPackage(classifier);
            this.knownClassifiers.add(classifier);
            if (classifier instanceof EClass) {
                EClass clazz = (EClass)classifier;
                Object clazzKey = this.toKey((EClassifier)clazz);
                for (EClass superType : clazz.getEAllSuperTypes()) {
                    this.maintainTypeHierarhyInternal(clazzKey, this.toKey((EClassifier)superType));
                }
                this.maintainTypeHierarhyInternal(clazzKey, this.getEObjectClassKey());
            } else if (classifier instanceof EEnum) {
                EEnum eEnum = (EEnum)classifier;
                if (this.isDynamicModel) {
                    if (eEnum.getInstanceClass() != null) {
                        this.generatedEENumClasses.put(eEnum.getInstanceClass(), eEnum);
                    }
                    for (EEnumLiteral eEnumLiteral : eEnum.getELiterals()) {
                        this.enumToKeyDynamicInternal((Enumerator)eEnumLiteral);
                    }
                }
            }
        }
    }

    private void checkEPackage(EClassifier classifier) {
        String nsURI;
        Collection packagesOfURI;
        EPackage ePackage = classifier.getEPackage();
        if (this.knownPackages.add(ePackage) && !(packagesOfURI = this.uniqueIDToPackage.get((Object)(nsURI = ePackage.getNsURI()))).contains(ePackage)) {
            this.uniqueIDToPackage.put((Object)nsURI, (Object)ePackage);
            if (!this.isDynamicModel && packagesOfURI.size() == 2) {
                this.navigationHelper.processingError(new ViatraBaseException("NsURI (" + nsURI + ") collision detected between different instances of EPackages. If this is normal, try using dynamic EMF mode."), "process new metamodel elements.");
            }
        }
    }

    private void maintainTypeHierarhyInternal(Object subClassKey, Object superClassKey) {
        Set<Object> subTypes;
        Table<Object, InstanceListener, Set<EClass>> instanceListeners;
        if (this.navigationHelper.directlyObservedClasses.containsKey(superClassKey)) {
            this.navigationHelper.getAllObservedClassesInternal().put(subClassKey, this.navigationHelper.directlyObservedClasses.get(superClassKey));
        }
        if ((instanceListeners = this.navigationHelper.peekInstanceListeners()) != null) {
            for (Map.Entry entry : instanceListeners.row(superClassKey).entrySet()) {
                InstanceListener listener = (InstanceListener)entry.getKey();
                for (EClass subscriptionType : (Set)entry.getValue()) {
                    this.navigationHelper.addInstanceListenerInternal(listener, subscriptionType, subClassKey);
                }
            }
        }
        if ((subTypes = this.subTypeMap.get(superClassKey)) == null) {
            subTypes = new HashSet<Object>();
            this.subTypeMap.put(superClassKey, subTypes);
        }
        subTypes.add(subClassKey);
        Set<Object> superTypes = this.superTypeMap.get(subClassKey);
        if (superTypes == null) {
            superTypes = new HashSet<Object>();
            this.superTypeMap.put(subClassKey, superTypes);
        }
        superTypes.add(superClassKey);
    }

    protected Map<Object, Set<Object>> getSubTypeMap() {
        return this.subTypeMap;
    }

    protected Map<Object, Set<Object>> getSuperTypeMap() {
        return this.superTypeMap;
    }

    public EStructuralFeature getKnownFeature(String featureId) {
        ETypedElement next;
        Collection features = this.uniqueIDToTypedElement.get((Object)featureId);
        if (features != null && !features.isEmpty() && (next = (ETypedElement)features.iterator().next()) instanceof EStructuralFeature) {
            return (EStructuralFeature)next;
        }
        return null;
    }

    public EStructuralFeature getKnownFeatureForKey(Object featureKey) {
        EStructuralFeature feature = this.isDynamicModel ? this.getKnownFeature((String)featureKey) : (EStructuralFeature)featureKey;
        return feature;
    }

    public EClassifier getKnownClassifier(String key) {
        Collection classifiersOfThisID = this.uniqueIDToClassifier.get((Object)key);
        if (classifiersOfThisID != null && !classifiersOfThisID.isEmpty()) {
            return (EClassifier)classifiersOfThisID.iterator().next();
        }
        return null;
    }

    public EClassifier getKnownClassifierForKey(Object classifierKey) {
        EClassifier cls = this.isDynamicModel ? this.getKnownClassifier((String)classifierKey) : (EClassifier)classifierKey;
        return cls;
    }
}

