/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.backend;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryHintOption;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public class QueryEvaluationHint {
    final IQueryBackendFactory queryBackendFactory;
    final Map<QueryHintOption, Object> backendHintSettings;

    public QueryEvaluationHint(Map<QueryHintOption, Object> backendHintSettings, IQueryBackendFactory queryBackendFactory) {
        this.queryBackendFactory = queryBackendFactory;
        this.backendHintSettings = backendHintSettings == null ? Collections.emptyMap() : ImmutableMap.copyOf(backendHintSettings);
    }

    public QueryEvaluationHint(IQueryBackendFactory queryBackendFactory, Map<String, Object> backendHints) {
        this(null, queryBackendFactory);
    }

    public IQueryBackendFactory getQueryBackendFactory() {
        return this.queryBackendFactory;
    }

    public Map<String, Object> getBackendHints() {
        return Collections.emptyMap();
    }

    public Map<QueryHintOption, Object> getBackendHintSettings() {
        return this.backendHintSettings;
    }

    public QueryEvaluationHint overrideBy(QueryEvaluationHint overridingHint) {
        if (overridingHint == null) {
            return this;
        }
        IQueryBackendFactory factory = this.getQueryBackendFactory();
        if (overridingHint.getQueryBackendFactory() != null) {
            factory = overridingHint.getQueryBackendFactory();
        }
        HashMap<QueryHintOption, Object> hints = new HashMap<QueryHintOption, Object>(this.getBackendHintSettings());
        if (overridingHint.getBackendHintSettings() != null) {
            hints.putAll(overridingHint.getBackendHintSettings());
        }
        return new QueryEvaluationHint(hints, factory);
    }

    public boolean isOptionOverridden(QueryHintOption<?> option) {
        return this.getBackendHintSettings().containsKey(option);
    }

    public <HintValue> HintValue getValueOrNull(QueryHintOption<HintValue> option) {
        return (HintValue)this.getBackendHintSettings().get(option);
    }

    public <HintValue> HintValue getValueOrDefault(QueryHintOption<HintValue> option) {
        return option.getValueOrDefault(this);
    }

    public IMatcherCapability calculateRequiredCapability(PQuery query) {
        return this.queryBackendFactory.calculateRequiredCapability(query, this);
    }

    public int hashCode() {
        return Objects.hash(this.backendHintSettings, this.queryBackendFactory);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryEvaluationHint other = (QueryEvaluationHint)obj;
        if (!Objects.equals(this.backendHintSettings, other.backendHintSettings)) {
            return false;
        }
        return Objects.equals(this.queryBackendFactory, other.queryBackendFactory);
    }

    public String toString() {
        String result;
        StringBuilder sb = new StringBuilder();
        if (this.getQueryBackendFactory() != null) {
            sb.append("backend: ").append(this.getQueryBackendFactory().getBackendClass().getSimpleName());
        }
        if (!this.backendHintSettings.isEmpty()) {
            sb.append("hints: ");
            if (this.backendHintSettings instanceof AbstractMap) {
                sb.append(this.backendHintSettings.toString());
            } else {
                String joinedHintMap = Joiner.on((String)", ").withKeyValueSeparator("=").join(this.backendHintSettings);
                sb.append('{').append(joinedHintMap).append('}');
            }
        }
        return (result = sb.toString()).isEmpty() ? "defaults" : result;
    }
}

