/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend.nobase;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;

public class IterateOverEStructuralFeatureInstances
implements ISearchOperation,
IIteratingSearchOperation {
    private final EStructuralFeature feature;
    private final int sourcePosition;
    private final int targetPosition;
    protected Iterator<Map.Entry<EObject, Object>> it;

    public IterateOverEStructuralFeatureInstances(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    @Override
    public void onBacktrack(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        frame.setValue(this.sourcePosition, null);
        frame.setValue(this.targetPosition, null);
        this.it = null;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        throw new UnsupportedOperationException("Implement onInitialize method first");
    }

    @Override
    public boolean execute(MatchingFrame frame, ISearchContext context) {
        throw new UnsupportedOperationException("Implement execute method first");
    }

    public String toString() {
        return "extend    " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(-" + this.sourcePosition + ", -" + this.targetPosition + ") iterating";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.sourcePosition, (Object)this.targetPosition, (Object[])new Integer[0]);
    }

    @Override
    public IInputKey getIteratedInputKey() {
        return new EStructuralFeatureInstancesKey(this.feature);
    }
}

