/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.viatra.addon.viewers.runtime.model.ContainmentRule;
import org.eclipse.viatra.addon.viewers.runtime.model.EdgeRule;
import org.eclipse.viatra.addon.viewers.runtime.model.ItemRule;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataModel;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.IViewerLabelListener;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.IViewerStateListener;
import org.eclipse.viatra.addon.viewers.runtime.model.patterns.Children;
import org.eclipse.viatra.addon.viewers.runtime.notation.Containment;
import org.eclipse.viatra.addon.viewers.runtime.notation.Edge;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.addon.viewers.runtime.notation.NotationModel;
import org.eclipse.viatra.addon.viewers.runtime.util.ViewerTraceabilityUtil;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.base.exception.ViatraBaseException;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.transformation.views.core.ViewModelManager;
import org.eclipse.viatra.transformation.views.core.ViewModelRule;
import org.eclipse.viatra.transformation.views.traceability.Traceability;

public class ViewerState
implements IViewerStateListener,
IViewerLabelListener {
    protected boolean hasExternalViewerDataModel = false;
    protected ViewerDataModel model;
    protected ViewerDataFilter filter;
    protected Collection<ViewerStateFeature> features;
    protected ViewModelManager manager;
    protected Collection<IViewerStateListener> stateListeners = Lists.newArrayList();
    protected Collection<IViewerLabelListener> labelListeners = Lists.newArrayList();
    private boolean disposed;

    public ViewerState(ViewerDataModel model, ViewerDataFilter filter, Collection<ViewerStateFeature> features) {
        this.model = model;
        this.filter = filter;
        this.features = features;
        this.manager = new ViewModelManager();
        try {
            this.manager.setEngine(model.getEngine());
            this.manager.setRules(this.collectRules(model));
            this.manager.initialize();
        }
        catch (ViatraBaseException | ViatraQueryException | QueryInitializationException e) {
            ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)e.getMessage());
        }
    }

    private Collection<ViewModelRule> collectRules(ViewerDataModel model) throws QueryInitializationException {
        ArrayList rules = Lists.newArrayList();
        for (IQuerySpecification<?> pattern : model.getPatterns()) {
            for (PAnnotation annotation : pattern.getAllAnnotations()) {
                if (this.features.contains((Object)ViewerStateFeature.EDGE) && annotation.getName().equals("Edge")) {
                    rules.add(EdgeRule.initiate(pattern, annotation, this, this.filter));
                }
                if (this.features.contains((Object)ViewerStateFeature.CONTAINMENT) && annotation.getName().equals("ContainsItem")) {
                    rules.add(ContainmentRule.initiate(pattern, annotation, this, this.filter));
                }
                if (!annotation.getName().equals("Item")) continue;
                rules.add(ItemRule.initiate(pattern, annotation, this, this.filter));
            }
        }
        return rules;
    }

    public Collection<Item> getChildren(Item parent) {
        try {
            Children.Matcher matcher = (Children.Matcher)this.model.getEngine().getMatcher((IQuerySpecification)Children.instance());
            Collection<Children.Match> matches = matcher.getAllMatches(parent, null);
            ArrayList items = Lists.newArrayList();
            for (Children.Match match : matches) {
                items.add(match.getChild());
            }
            return items;
        }
        catch (ViatraQueryException e) {
            ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public Item getParent(Item child) {
        return child.getParent();
    }

    @Override
    public final void itemAppeared(Item item) {
        for (IViewerStateListener l : this.stateListeners) {
            l.itemAppeared(item);
        }
    }

    @Override
    public final void itemDisappeared(Item item) {
        for (IViewerStateListener l : this.stateListeners) {
            l.itemDisappeared(item);
        }
    }

    @Override
    public final void containmentAppeared(Containment containment) {
        for (IViewerStateListener l : this.stateListeners) {
            l.containmentAppeared(containment);
        }
    }

    @Override
    public final void containmentDisappeared(Containment containment) {
        for (IViewerStateListener l : this.stateListeners) {
            l.containmentDisappeared(containment);
        }
    }

    @Override
    public final void edgeAppeared(Edge edge) {
        for (IViewerStateListener l : this.stateListeners) {
            l.edgeAppeared(edge);
        }
    }

    @Override
    public final void edgeDisappeared(Edge edge) {
        for (IViewerStateListener l : this.stateListeners) {
            l.edgeDisappeared(edge);
        }
    }

    @Override
    public final void labelUpdated(Item item, String newLabel) {
        for (IViewerLabelListener l : this.labelListeners) {
            l.labelUpdated(item, newLabel);
        }
    }

    @Override
    public final void labelUpdated(Edge edge, String newLabel) {
        for (IViewerLabelListener l : this.labelListeners) {
            l.labelUpdated(edge, newLabel);
        }
    }

    public void addStateListener(IViewerStateListener listener) {
        this.stateListeners.add(listener);
    }

    public void removeStateListener(IViewerStateListener listener) {
        this.stateListeners.remove(listener);
    }

    public void addLabelListener(IViewerLabelListener listener) {
        this.labelListeners.add(listener);
    }

    public void removeLabelListener(IViewerLabelListener listener) {
        this.labelListeners.remove(listener);
    }

    public Collection<Item> getItemsFor(Object target) {
        return ViewerTraceabilityUtil.traceToItem(this.model.getEngine(), target);
    }

    public Collection<Item> getItems() {
        return this.model.getNotationModel().getItems();
    }

    public Collection<Edge> getEdges() {
        return this.model.getNotationModel().getEdges();
    }

    public Collection<Containment> getContainments() {
        return this.model.getNotationModel().getContainments();
    }

    public ViewModelManager getManager() {
        return this.manager;
    }

    public NotationModel getNotationModel() {
        return this.model.getNotationModel();
    }

    public Traceability getTraceability() {
        return this.manager.getTraceability();
    }

    public ViatraQueryEngine getEngine() {
        return this.model.getEngine();
    }

    public void dispose() {
        this.manager.dispose();
        if (!this.hasExternalViewerDataModel) {
            this.model.dispose();
        }
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public static enum ViewerStateFeature {
        EDGE,
        CONTAINMENT;

    }
}

