/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternComponent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.patternsviewer.PatternLeaf;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;

public class CheckStateListener
implements ICheckStateListener {
    private final QueryExplorer queryExplorer;
    private final ILog logger = ViatraQueryGUIPlugin.getDefault().getLog();

    public CheckStateListener(QueryExplorer queryExplorer) {
        this.queryExplorer = queryExplorer;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        Collection<PatternComponent> changedComponents = ((PatternComponent)element).setCheckedState(event.getChecked());
        for (PatternComponent component : changedComponents) {
            if (!(component instanceof PatternLeaf)) continue;
            String patternFqn = ((PatternLeaf)component).getFullPatternNamePrefix();
            IQuerySpecification<?> specification = QueryExplorerPatternRegistry.getInstance().getPatternByFqn(patternFqn);
            if (specification != null) {
                PatternMatcherRootContent root;
                Iterator<PatternMatcherRootContent> iterator;
                if (event.getChecked() && !QueryExplorerPatternRegistry.getInstance().isActive(patternFqn)) {
                    iterator = QueryExplorer.getInstance().getRootContent().getChildrenIterator();
                    while (iterator.hasNext()) {
                        root = iterator.next();
                        root.registerPattern(this.queryExplorer.getHints(), specification);
                        root.updateHasChildren();
                    }
                    QueryExplorerPatternRegistry.getInstance().addActivePattern(specification);
                    continue;
                }
                if (event.getChecked()) continue;
                iterator = QueryExplorer.getInstance().getRootContent().getChildrenIterator();
                while (iterator.hasNext()) {
                    root = iterator.next();
                    root.unregisterPattern(specification);
                    root.updateHasChildren();
                }
                QueryExplorerPatternRegistry.getInstance().removeActivePattern(specification);
                continue;
            }
            this.logger.log((IStatus)new Status(2, "org.eclipse.viatra.query.tooling.ui", String.valueOf(patternFqn) + "not found in QueryExplorerPatternRegistry"));
        }
    }
}

