/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ui.IEditorPart;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.CompositeContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.ContentChildren;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContentKey;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.RootContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.QueryExplorerPatternRegistry;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherCollection;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;

public class PatternMatcherRootContent
extends CompositeContent<RootContent, PatternMatcherContent>
implements IFilteredMatcherCollection {
    private final Map<String, PatternMatcherContent> mapping;
    private ContentChildren<PatternMatcherContent> children;
    private final PatternMatcherRootContentKey key;
    private ViatraQueryEngineLifecycleListener taintListener;
    private final ILog logger = ViatraQueryGUIPlugin.getDefault().getLog();
    private IStatus contentStatus;

    public PatternMatcherRootContent(RootContent parent, PatternMatcherRootContentKey key) {
        super(parent);
        this.children = new ContentChildren();
        this.taintListener = new ContentEngineTaintListener();
        this.mapping = Maps.newHashMap();
        this.key = key;
        AdvancedViatraQueryEngine engine = key.getEngine();
        if (engine == null) {
            engine = this.createEngine();
            key.setEngine(engine);
            ExecutionSchema ruleEngine = ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)engine));
            key.setRuleEngine((RuleEngine)ruleEngine);
            engine.addLifecycleListener(this.taintListener);
        }
    }

    private AdvancedViatraQueryEngine createEngine() {
        boolean wildcardMode = ViatraQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.viatra.query.tooling.ui.queryexplorer.WildcardMode");
        boolean dynamicEMFMode = ViatraQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.viatra.query.tooling.ui.queryexplorer.DynamicEMFMode");
        try {
            BaseIndexOptions options = new BaseIndexOptions(dynamicEMFMode, wildcardMode);
            EMFScope scope = new EMFScope(this.key.getNotifier(), options);
            AdvancedViatraQueryEngine engine = AdvancedViatraQueryEngine.createUnmanagedEngine((QueryScope)scope);
            return engine;
        }
        catch (ViatraQueryException e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.viatra.query.tooling.ui", "Could not retrieve ViatraQueryEngine for " + this.key.getNotifier(), (Throwable)e));
            return null;
        }
    }

    public void registerPattern(final QueryEvaluationHint hint, final IQuerySpecification<?> ... patterns) {
        AdvancedViatraQueryEngine engine = null;
        try {
            engine = this.key.getEngine();
            engine.getBaseIndex().coalesceTraversals((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    PatternMatcherRootContent.this.addMatchersForPatterns(hint, patterns);
                    return null;
                }
            });
            this.contentStatus = Status.OK_STATUS;
        }
        catch (ViatraQueryException ex) {
            this.reportMatcherError("Cannot initialize pattern matcher engine.", ex);
        }
        catch (InvocationTargetException e) {
            this.reportMatcherError("Error during pattern matcher construction: " + e.getCause().getMessage(), e.getCause());
        }
    }

    private void addMatchersForPatterns(QueryEvaluationHint hint, IQuerySpecification<?> ... queries) {
        IQuerySpecification<?>[] iQuerySpecificationArray = queries;
        int n = queries.length;
        int n2 = 0;
        while (n2 < n) {
            IQuerySpecification<?> query = iQuerySpecificationArray[n2];
            boolean isGenerated = QueryExplorerPatternRegistry.getInstance().isGenerated(query);
            this.addMatcher(this.key.getEngine(), this.key.getRuleEngine(), query, isGenerated, hint);
            ++n2;
        }
    }

    public void addMatcher(AdvancedViatraQueryEngine engine, RuleEngine ruleEngine, IQuerySpecification<?> specification, boolean generated, QueryEvaluationHint hint) {
        String fqn = specification.getFullyQualifiedName();
        PatternMatcherContent pm = new PatternMatcherContent(this, engine, ruleEngine, specification, generated, hint);
        this.mapping.put(fqn, pm);
        if (generated) {
            this.children.addChild(0, pm);
        } else {
            this.children.addChild(pm);
        }
    }

    public void unregisterPattern(IQuerySpecification<?> specification) {
        this.removeMatcher(specification.getFullyQualifiedName());
    }

    public void removeMatcher(String patternFqn) {
        PatternMatcherContent matcher = this.mapping.get(patternFqn);
        if (matcher != null) {
            matcher.dispose();
            this.children.removeChild(matcher);
            IObservableList observableList = matcher.getChildren();
            if (observableList != null && !observableList.isDisposed()) {
                observableList.dispose();
            }
            this.mapping.remove(patternFqn);
        }
    }

    @Override
    public void dispose() {
        AdvancedViatraQueryEngine engine;
        super.dispose();
        RuleEngine ruleEngine = this.key.getRuleEngine();
        if (ruleEngine != null) {
            ruleEngine.dispose();
        }
        if ((engine = this.key.getEngine()) != null) {
            engine.removeLifecycleListener(this.taintListener);
            engine.dispose();
        }
    }

    public boolean isTainted() {
        AdvancedViatraQueryEngine engine = this.key.getEngine();
        return engine == null ? true : engine.isTainted();
    }

    public PatternMatcherRootContentKey getKey() {
        return this.key;
    }

    public IEditorPart getEditorPart() {
        return this.key.getEditorPart();
    }

    public Notifier getNotifier() {
        return this.key.getNotifier();
    }

    private void reportMatcherError(String message, Throwable t) {
        this.contentStatus = t != null ? new Status(4, "org.eclipse.viatra.query.tooling.ui", message, t) : new Status(4, "org.eclipse.viatra.query.tooling.ui", message);
        this.logger.log(this.contentStatus);
        ((RootContent)this.getParent()).getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((RootContent)PatternMatcherRootContent.this.getParent()).getViewer().refresh((Object)this);
            }
        });
    }

    @Override
    public String getText() {
        return this.key.toString();
    }

    @Override
    public IObservableList getChildren() {
        return this.children;
    }

    @Override
    public Iterable<IFilteredMatcherContent> getFilteredMatchers() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (PatternMatcherContent matcher : this.children.getElements()) {
            builder.add((Object)matcher);
        }
        return builder.build();
    }

    @Override
    public Iterator<PatternMatcherContent> getChildrenIterator() {
        return this.children.getElements().iterator();
    }

    public IStatus getStatus() {
        return this.contentStatus;
    }

    private class ContentEngineTaintListener
    implements ViatraQueryEngineLifecycleListener {
        private ContentEngineTaintListener() {
        }

        public void engineBecameTainted(String description, Throwable t) {
            PatternMatcherRootContent.this.reportMatcherError(description, t);
        }

        public void matcherInstantiated(ViatraQueryMatcher<? extends IPatternMatch> matcher) {
        }

        public void engineWiped() {
        }

        public void engineDisposed() {
        }
    }
}

