/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.runtime.Assert;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.CompositeContent;

public class ContentChildren<E>
extends AbstractObservableList {
    private static final String REALM_MUST_NOT_BE_NULL = "Data binding Realm must not be null";
    private List<E> elements = new LinkedList();

    public Object getElementType() {
        return CompositeContent.class;
    }

    protected int doGetSize() {
        return this.elements.size();
    }

    public Object get(int index) {
        return this.elements.get(index);
    }

    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    public List<E> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public boolean addChild(E element) {
        return this.addChild(this.elements.size(), element);
    }

    public boolean addChild(int position, E element) {
        ListDiffEntry diffentry = Diffs.createListDiffEntry((int)position, (boolean)true, element);
        this.elements.add(position, element);
        final ListDiff diff = Diffs.createListDiff((ListDiffEntry)diffentry);
        Realm realm = this.getRealm();
        Assert.isNotNull((Object)realm, (String)REALM_MUST_NOT_BE_NULL);
        realm.exec(new Runnable(){

            @Override
            public void run() {
                if (!ContentChildren.this.isDisposed()) {
                    ContentChildren.this.fireListChange(diff);
                }
            }
        });
        return true;
    }

    public boolean removeChild(E element) {
        int index = this.elements.indexOf(element);
        ListDiffEntry diffentry = Diffs.createListDiffEntry((int)index, (boolean)false, element);
        boolean res = this.elements.remove(element);
        final ListDiff diff = Diffs.createListDiff((ListDiffEntry)diffentry);
        Realm realm = this.getRealm();
        Assert.isNotNull((Object)realm, (String)REALM_MUST_NOT_BE_NULL);
        realm.exec(new Runnable(){

            @Override
            public void run() {
                if (!ContentChildren.this.isDisposed()) {
                    ContentChildren.this.fireListChange(diff);
                }
            }
        });
        return res;
    }
}

