/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.LayoutAlgorithm;
import org.eclipse.gef4.layout.interfaces.EntityLayout;
import org.eclipse.gef4.layout.interfaces.LayoutContext;

public class GridLayoutAlgorithm
implements LayoutAlgorithm {
    private static final double PADDING_PERCENTAGE = 0.95;
    private static final int MIN_ENTITY_SIZE = 5;
    protected double aspectRatio = 1.0;
    protected int rowPadding = 0;
    private boolean resize = false;
    protected int rows;
    protected int cols;
    protected int numChildren;
    protected double colWidth;
    protected double rowHeight;
    protected double offsetX;
    protected double offsetY;
    protected double childrenHeight;
    protected double childrenWidth;
    private LayoutContext context;

    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        Rectangle bounds = this.context.getBounds();
        this.calculateGrid(bounds);
        this.applyLayoutInternal(this.context.getEntities(), bounds);
    }

    protected void calculateGrid(Rectangle bounds) {
        this.numChildren = this.context.getNodes().length;
        int[] result = this.calculateNumberOfRowsAndCols(this.numChildren, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.cols = result[0];
        this.rows = result[1];
        this.colWidth = bounds.getWidth() / (double)this.cols;
        this.rowHeight = bounds.getHeight() / (double)this.rows;
        double[] nodeSize = this.calculateNodeSize(this.colWidth, this.rowHeight);
        this.childrenWidth = nodeSize[0];
        this.childrenHeight = nodeSize[1];
        this.offsetX = (this.colWidth - this.childrenWidth) / 2.0;
        this.offsetY = (this.rowHeight - this.childrenHeight) / 2.0;
    }

    protected synchronized void applyLayoutInternal(EntityLayout[] entitiesToLayout, Rectangle bounds) {
        int index = 0;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (i * this.cols + j < this.numChildren) {
                    EntityLayout node = entitiesToLayout[index++];
                    if (this.resize && node.isResizable()) {
                        node.setSize(Math.max(this.childrenWidth, 5.0), Math.max(this.childrenHeight, 5.0));
                    }
                    Dimension size = node.getSize();
                    double xmove = bounds.getX() + (double)j * this.colWidth + this.offsetX + size.width / 2.0;
                    double ymove = bounds.getY() + (double)i * this.rowHeight + this.offsetY + size.height / 2.0;
                    if (node.isMovable()) {
                        node.setLocation(xmove, ymove);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected int[] calculateNumberOfRowsAndCols(int numChildren, double boundX, double boundY, double boundWidth, double boundHeight) {
        if (this.aspectRatio == 1.0) {
            return this.calculateNumberOfRowsAndCols_square(numChildren, boundX, boundY, boundWidth, boundHeight);
        }
        return this.calculateNumberOfRowsAndCols_rectangular(numChildren);
    }

    /*
     * Unable to fully structure code
     */
    protected int[] calculateNumberOfRowsAndCols_square(int numChildren, double boundX, double boundY, double boundWidth, double boundHeight) {
        block6: {
            rows = Math.max(1, (int)Math.sqrt((double)numChildren * boundHeight / boundWidth));
            cols = Math.max(1, (int)Math.sqrt((double)numChildren * boundWidth / boundHeight));
            if (!(boundWidth <= boundHeight)) ** GOTO lbl19
            while (rows * cols > numChildren) {
                if (rows > 1) {
                    --rows;
                }
                if (rows * cols <= numChildren || cols <= 1) continue;
                --cols;
            }
            while (rows * cols < numChildren) {
                if (++rows * cols >= numChildren) continue;
                ++cols;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                if (cols > 1) {
                    --cols;
                }
                if (rows * cols <= numChildren || rows <= 1) continue;
                --rows;
lbl19:
                // 3 sources

                ** while (rows * cols > numChildren)
            }
lbl20:
            // 3 sources

            while (rows * cols < numChildren) {
                if (rows * ++cols >= numChildren) continue;
                ++rows;
            }
        }
        result = new int[]{cols, rows};
        return result;
    }

    protected int[] calculateNumberOfRowsAndCols_rectangular(int numChildren) {
        int rows = Math.max(1, (int)Math.ceil(Math.sqrt(numChildren)));
        int cols = Math.max(1, (int)Math.ceil(Math.sqrt(numChildren)));
        int[] result = new int[]{cols, rows};
        return result;
    }

    protected double[] calculateNodeSize(double colWidth, double rowHeight) {
        double childW = Math.max(5.0, 0.95 * colWidth);
        double childH = Math.max(5.0, 0.95 * (rowHeight - (double)this.rowPadding));
        double whRatio = colWidth / rowHeight;
        if (whRatio < this.aspectRatio) {
            childH = childW / this.aspectRatio;
        } else {
            childW = childH * this.aspectRatio;
        }
        double[] result = new double[]{childW, childH};
        return result;
    }

    public void setRowPadding(int rowPadding) {
        if (rowPadding >= 0) {
            this.rowPadding = rowPadding;
        }
    }

    public void setAspectRatio(double aspectRatio) {
        if (aspectRatio > 0.0) {
            this.aspectRatio = aspectRatio;
        }
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
    }

    public LayoutContext getLayoutContext() {
        return this.context;
    }
}

