/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.map.primitive;

import java.util.Collection;
import java.util.Map;

import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.predicate.primitive.DoubleObjectPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleObjectPair;

/**
 * This file was automatically generated from template file primitiveObjectMap.stg.
 *
 * @since 3.0.
 */
public interface DoubleObjectMap<V> extends RichIterable<V>
{
    V get(double key);

    V getIfAbsent(double key, Function0<? extends V> ifAbsent);

    boolean containsKey(double key);

    boolean containsValue(Object value);

    DoubleObjectMap<V> tap(Procedure<? super V> procedure);

    void forEachValue(Procedure<? super V> procedure);

    void forEachKey(DoubleProcedure procedure);

    void forEachKeyValue(DoubleObjectProcedure<? super V> procedure);

    DoubleObjectMap<V> select(DoubleObjectPredicate<? super V> predicate);

    DoubleObjectMap<V> reject(DoubleObjectPredicate<? super V> predicate);

    /**
     * Follows the same general contract as {@link Map#equals(Object)}.
     */
    @Override
    boolean equals(Object o);

    /**
     * Follows the same general contract as {@link Map#hashCode()}.
     */
    @Override
    int hashCode();

    /**
     * Returns a string representation of this DoubleObjectMap. The string representation consists of a list of the
     * map's key-value pairs in the order they are returned by its iterator. The key and value in each key-value pair are separated
     * by a colon (<tt>":"</tt>) and each pair is enclosed in square brackets (<tt>"[]"</tt>). Adjacent key-value pairs
     * are separated by the characters <tt>", "</tt> (comma and space). Keys and values are converted to strings as by
     * String#valueOf().
     *
     * @return a string representation of this DoubleObjectMap
     */
    String toString();

    ImmutableDoubleObjectMap<V> toImmutable();

    MutableDoubleSet keySet();

    Collection<V> values();

    /**
     * @since 5.0
     */
    LazyDoubleIterable keysView();

    /**
     * @since 5.0
     */
    RichIterable<DoubleObjectPair<V>> keyValuesView();
}
