/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.search;

import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class HelpCriteriaContentProvider
implements ITreeContentProvider {
    public static final String UNCATEGORIZED = "Uncategorized";

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof String[]) {
            String[] names = (String[])parentElement;
            Object[] criterionNames = new CriterionName[names.length];
            int i = 0;
            while (i < names.length) {
                criterionNames[i] = new CriterionName(names[i], parentElement);
                ++i;
            }
            return criterionNames;
        }
        if (parentElement instanceof CriterionName) {
            CriterionName parentCriterion = (CriterionName)parentElement;
            String[] values = BaseHelpSystem.getWorkingSetManager().getCriterionValueIds(parentCriterion.getId());
            Object[] criterionValues = new CriterionValue[values.length];
            int i = 0;
            while (i < values.length) {
                criterionValues[i] = new CriterionValue(values[i], parentElement);
                ++i;
            }
            return criterionValues;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof CriterionName) {
            return ((CriterionName)element).getParent();
        }
        if (element instanceof CriterionValue) {
            return ((CriterionValue)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public static class CriterionName {
        private final String id;
        private final Object parent;

        public CriterionName(String id, Object parent) {
            this.id = id;
            this.parent = parent;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return HelpPlugin.getCriteriaManager().getCriterionDisplayName(this.id, Platform.getNL());
        }

        public Object getParent() {
            return this.parent;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof CriterionName) {
                CriterionName other = (CriterionName)arg0;
                return other.id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public static class CriterionValue {
        private final String id;
        private final Object parent;

        public CriterionValue(String id, Object parent) {
            this.id = id;
            this.parent = parent;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            if (this.id.equals(HelpCriteriaContentProvider.UNCATEGORIZED)) {
                return Messages.UncategorizedCriteria;
            }
            CriterionName parentCriterion = (CriterionName)this.parent;
            return HelpPlugin.getCriteriaManager().getCriterionValueDisplayName(parentCriterion.id, this.id, Platform.getNL());
        }

        public Object getParent() {
            return this.parent;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof CriterionValue) {
                CriterionValue other = (CriterionValue)arg0;
                return other.id.equals(this.id) && this.parent.equals(other.parent);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode() + this.parent.hashCode();
        }
    }
}

