/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ArchiveUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TarFile;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;

public class TarLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private TarFile tarFile;
    private TarArchiveEntry root = new TarArchiveEntry("/", true);
    private Map<TarArchiveEntry, List<TarArchiveEntry>> children;
    private Map<IPath, TarArchiveEntry> directoryEntryCache = new HashMap<IPath, TarArchiveEntry>();
    private int stripLevel;

    public TarLeveledStructureProvider(TarFile sourceFile) {
        this.tarFile = sourceFile;
    }

    protected TarArchiveEntry createContainer(IPath pathName) {
        IPath newPathName = pathName;
        TarArchiveEntry existingEntry = this.directoryEntryCache.get(newPathName);
        if (existingEntry != null) {
            return existingEntry;
        }
        TarArchiveEntry parent = newPathName.segmentCount() == 1 ? this.root : this.createContainer(newPathName.removeLastSegments(1));
        newPathName = newPathName.addTrailingSeparator();
        TarArchiveEntry newEntry = new TarArchiveEntry(newPathName.toString());
        this.directoryEntryCache.put(newPathName, newEntry);
        ArrayList childList = new ArrayList();
        this.children.put(newEntry, childList);
        List<TarArchiveEntry> parentChildList = this.children.get(parent);
        ((List)NonNullUtils.checkNotNull(parentChildList)).add(newEntry);
        return newEntry;
    }

    protected void createFile(TarArchiveEntry entry) {
        Path pathname = new Path(entry.getName());
        TarArchiveEntry parent = pathname.segmentCount() == 1 ? this.root : this.directoryEntryCache.get(pathname.removeLastSegments(1));
        List<TarArchiveEntry> childList = this.children.get(parent);
        ((List)NonNullUtils.checkNotNull(childList)).add(entry);
    }

    public List getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return this.children.get(element);
    }

    public InputStream getContents(Object element) {
        try {
            return this.tarFile.getInputStream((TarArchiveEntry)element);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public ResourceAttributes getResourceAttributes(Object element) {
        ResourceAttributes attributes = new ResourceAttributes();
        TarArchiveEntry entry = (TarArchiveEntry)element;
        attributes.setExecutable((entry.getMode() & 0x40) != 0);
        attributes.setReadOnly((entry.getMode() & 0x80) == 0);
        return attributes;
    }

    public String getFullPath(Object element) {
        String name = this.stripPath(((TarArchiveEntry)element).getName());
        return ArchiveUtil.toValidNamesPath(name).toOSString();
    }

    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((TarArchiveEntry)element).getName();
        }
        String name = ((TarArchiveEntry)element).getName();
        return this.stripPath(ArchiveUtil.toValidNamesPath(name).lastSegment());
    }

    public Object getRoot() {
        return this.root;
    }

    public TarFile getTarFile() {
        return this.tarFile;
    }

    public boolean closeArchive() {
        try {
            this.getTarFile().close();
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)(String.valueOf(DataTransferMessages.ZipImport_couldNotClose) + this.getTarFile().getName()), (Throwable)e);
            return false;
        }
        return true;
    }

    public void close() {
        this.closeArchive();
    }

    protected void initialize() {
        this.children = new HashMap<TarArchiveEntry, List<TarArchiveEntry>>(1000);
        this.children.put(this.root, new ArrayList());
        Enumeration<TarArchiveEntry> entries = this.tarFile.entries();
        while (entries.hasMoreElements()) {
            TarArchiveEntry entry = entries.nextElement();
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            if (entry.isDirectory()) {
                this.createContainer(path);
                continue;
            }
            int pathSegmentCount = path.segmentCount();
            if (pathSegmentCount > 1) {
                this.createContainer(path.uptoSegment(pathSegmentCount - 1));
            }
            this.createFile(entry);
        }
    }

    public boolean isFolder(Object element) {
        return ((TarArchiveEntry)element).isDirectory();
    }

    private String stripPath(String path) {
        String strippedPath;
        String pathOrig = strippedPath = path;
        int i = 0;
        while (i < this.stripLevel) {
            int firstSep = strippedPath.indexOf(47);
            if (firstSep == 0) {
                strippedPath = strippedPath.substring(1);
                firstSep = strippedPath.indexOf(47);
            }
            if (firstSep == -1) {
                return pathOrig;
            }
            strippedPath = strippedPath.substring(firstSep);
            ++i;
        }
        return strippedPath;
    }

    public void setStrip(int level) {
        this.stripLevel = level;
    }

    public int getStrip() {
        return this.stripLevel;
    }
}

