/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.core;

/**
 * One of the series in a {@link ITimeSeries}
 *
 * <p>
 * Each series consists of one or more {@link ITSPoints} blocks which must be inserted consecutively.
 * </p>
 */
public interface ITSSeries extends IAttributeAware {
    /**
     * Add a {@link ITSPoints} block to the series
     *
     * @param data {@link ITSPoints} block to be added
     */
    void addData(ITSPoints data);

    /**
     * @return the number of {@link ITSPoints} in this {@link ITSSeries}
     */
    int getSize();

    /**
     * @return an iterable of all {@link ITSPoints} blocks in the series
     */
    Iterable<ITSPoints> getData();

    /**
     * @return the first recorded timestamp in the series
     */
    Double getStartTime();

    /**
     * @return the last recorded timestamp in the series
     */
    Double getEndTime();

    /**
     * @return true if the series does not contain any data
     */
    boolean isEmpty();
}
