/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.analysis.mtl.AtomicProposition;
import org.eclipse.trace4cps.analysis.mtl.DefaultAtomicProposition;
import org.eclipse.trace4cps.analysis.mtl.MtlBuilder;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.analysis.stl.StlBuilder;
import org.eclipse.trace4cps.analysis.stl.StlFormula;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.Interval;
import org.eclipse.trace4cps.tl.FormulaBuilderException;
import org.eclipse.trace4cps.tl.FormulaHelper;
import org.eclipse.trace4cps.tl.VerificationResult;
import org.eclipse.trace4cps.tl.etl.AndOrFormula;
import org.eclipse.trace4cps.tl.etl.ApFormula;
import org.eclipse.trace4cps.tl.etl.AttributeFilter;
import org.eclipse.trace4cps.tl.etl.Check;
import org.eclipse.trace4cps.tl.etl.Def;
import org.eclipse.trace4cps.tl.etl.EtlModel;
import org.eclipse.trace4cps.tl.etl.FinallyFormula;
import org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula;
import org.eclipse.trace4cps.tl.etl.Formula;
import org.eclipse.trace4cps.tl.etl.GloballyFormula;
import org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula;
import org.eclipse.trace4cps.tl.etl.IdString;
import org.eclipse.trace4cps.tl.etl.IfThenFormula;
import org.eclipse.trace4cps.tl.etl.KeyVal;
import org.eclipse.trace4cps.tl.etl.MtlAp;
import org.eclipse.trace4cps.tl.etl.MtlApEnd;
import org.eclipse.trace4cps.tl.etl.MtlApStart;
import org.eclipse.trace4cps.tl.etl.NotFormula;
import org.eclipse.trace4cps.tl.etl.ReferenceFormula;
import org.eclipse.trace4cps.tl.etl.SignalDef;
import org.eclipse.trace4cps.tl.etl.StlAp;
import org.eclipse.trace4cps.tl.etl.StlApDeriv;
import org.eclipse.trace4cps.tl.etl.TopLevelModelElement;
import org.eclipse.trace4cps.tl.etl.UntilFormula;
import org.eclipse.trace4cps.tl.etl.UntilUntimedFormula;

public class FormulaBuilder {
    private final ITrace trace;
    private final EtlModel m;
    private final VerificationResult result;
    private final Map<String, IPsop> signalMap;

    public FormulaBuilder(ITrace trace, Map<String, IPsop> signalMap, EtlModel m) throws FormulaBuilderException {
        this.trace = trace;
        this.m = m;
        this.result = new VerificationResult();
        this.signalMap = signalMap;
    }

    public static <T extends TopLevelModelElement> List<T> get(EtlModel model, Class<T> clazz) {
        ArrayList<TopLevelModelElement> r = new ArrayList<TopLevelModelElement>();
        for (TopLevelModelElement e : model.getElements()) {
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            r.add((TopLevelModelElement)clazz.cast(e));
        }
        return r;
    }

    public VerificationResult create() throws FormulaBuilderException {
        for (Check chk : FormulaBuilder.get(this.m, Check.class)) {
            String name = chk.getName();
            if (chk.getVar() != null) {
                int i = chk.getLb();
                while (i <= chk.getUb()) {
                    MtlFormula f = FormulaBuilder.create(chk.getFormula(), i, this.trace.getTimeUnit(), this.signalMap, this.result);
                    this.result.add(name, f, i);
                    ++i;
                }
                continue;
            }
            MtlFormula f = FormulaBuilder.create(chk.getFormula(), null, this.trace.getTimeUnit(), this.signalMap, this.result);
            this.result.add(name, f, true);
        }
        return this.result;
    }

    public static Map<String, String> toMap(AttributeFilter kvs, Integer i) {
        HashMap<String, String> filter = new HashMap<String, String>();
        for (KeyVal kv : kvs.getKeyVals()) {
            filter.put(FormulaBuilder.getIdString(kv.getAtt(), i), FormulaBuilder.getIdString(kv.getVal(), i));
        }
        return filter;
    }

    public static String getIdString(IdString ids, Integer i) {
        StringBuilder b = new StringBuilder();
        if (ids.getLeft() != null) {
            b.append(ids.getLeft());
        }
        if (ids.getId() != null) {
            b.append(i.toString());
        }
        if (ids.getRight() != null) {
            b.append(ids.getRight());
        }
        return b.toString();
    }

    public static MtlFormula create(Formula f, ITrace trace, List<SignalDef> signalDefs) throws FormulaBuilderException {
        Map<String, IPsop> signalMap = FormulaHelper.createSignalMap(trace, signalDefs, true);
        return FormulaBuilder.create(f, null, trace.getTimeUnit(), signalMap, null);
    }

    public static MtlFormula create(Formula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        if (f instanceof ReferenceFormula) {
            return FormulaBuilder.createRef((ReferenceFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof ApFormula) {
            return FormulaBuilder.createAp((ApFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof AndOrFormula) {
            return FormulaBuilder.createAndOr((AndOrFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof IfThenFormula) {
            return FormulaBuilder.createImply((IfThenFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof NotFormula) {
            return FormulaBuilder.createNot((NotFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof FinallyUntimedFormula) {
            return FormulaBuilder.createF0((FinallyUntimedFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof FinallyFormula) {
            return FormulaBuilder.createF1((FinallyFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof GloballyUntimedFormula) {
            return FormulaBuilder.createG0((GloballyUntimedFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof GloballyFormula) {
            return FormulaBuilder.createG1((GloballyFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof UntilUntimedFormula) {
            return FormulaBuilder.createU0((UntilUntimedFormula)f, qValue, traceTu, signalMap, result);
        }
        if (f instanceof UntilFormula) {
            return FormulaBuilder.createU1((UntilFormula)f, qValue, traceTu, signalMap, result);
        }
        throw new IllegalStateException("Failed to create formula for " + String.valueOf(f));
    }

    private static MtlFormula createAndOr(AndOrFormula ao, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        switch (ao.getOp()) {
            case AND: {
                return FormulaBuilder.createAnd(ao, qValue, traceTu, signalMap, result);
            }
            case OR: {
                return FormulaBuilder.createOr(ao, qValue, traceTu, signalMap, result);
            }
        }
        throw new IllegalStateException();
    }

    private static MtlFormula createAp(ApFormula ap, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        if (ap.getMtlAP() != null) {
            return FormulaBuilder.createMTL(ap.getMtlAP(), qValue);
        }
        return FormulaBuilder.createSTL(ap.getStlAP(), qValue, traceTu, signalMap, result);
    }

    private static MtlFormula createRef(ReferenceFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        Def def = f.getDef();
        int addend = f.getVal();
        MtlFormula defFormula = FormulaBuilder.create(def.getFormula(), qValue == null ? null : Integer.valueOf(qValue + addend), traceTu, signalMap, result);
        Object name = def.getName();
        if (qValue != null) {
            name = (String)name + "(" + (qValue + addend) + ")";
        }
        if (result != null && !result.contains(defFormula)) {
            result.add((String)name, defFormula, false);
        }
        return defFormula;
    }

    private static AtomicProposition createMTL(MtlAp f, Integer qValue) throws FormulaBuilderException {
        HashMap<String, String> props = new HashMap<String, String>();
        AttributeFilter keyVals = f.getFilter();
        for (KeyVal kv : keyVals.getKeyVals()) {
            props.put(FormulaBuilder.getIdString(kv.getAtt(), qValue), FormulaBuilder.getIdString(kv.getVal(), qValue));
        }
        if (f instanceof MtlApStart) {
            return new DefaultAtomicProposition(ClaimEventType.START, props);
        }
        if (f instanceof MtlApEnd) {
            return new DefaultAtomicProposition(ClaimEventType.END, props);
        }
        return new DefaultAtomicProposition(props);
    }

    private static MtlFormula createSTL(StlAp f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        IPsop p = signalMap.get(f.getRef().getName());
        if (f instanceof StlApDeriv) {
            p = PsopHelper.createDerivativeOf((IPsop)p);
        }
        double val = f.getVal();
        switch (f.getCompOp()) {
            case EQ: {
                return StlBuilder.EQ((IPsop)p, (double)val);
            }
            case GE: {
                return StlBuilder.GEQ((IPsop)p, (double)val);
            }
            case LE: {
                return StlBuilder.LEQ((IPsop)p, (double)val);
            }
        }
        throw new IllegalStateException();
    }

    private static MtlFormula createAnd(AndOrFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula l = FormulaBuilder.create(f.getLeft(), qValue, traceTu, signalMap, result);
        MtlFormula r = FormulaBuilder.create(f.getRight(), qValue, traceTu, signalMap, result);
        if (l instanceof StlFormula && r instanceof StlFormula) {
            return StlBuilder.AND((StlFormula)((StlFormula)l), (StlFormula)((StlFormula)r));
        }
        return MtlBuilder.AND((MtlFormula)l, (MtlFormula)r);
    }

    private static MtlFormula createOr(AndOrFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula l = FormulaBuilder.create(f.getLeft(), qValue, traceTu, signalMap, result);
        MtlFormula r = FormulaBuilder.create(f.getRight(), qValue, traceTu, signalMap, result);
        if (l instanceof StlFormula && r instanceof StlFormula) {
            return StlBuilder.OR((StlFormula)((StlFormula)l), (StlFormula)((StlFormula)r));
        }
        return MtlBuilder.OR((MtlFormula)l, (MtlFormula)r);
    }

    private static MtlFormula createImply(IfThenFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula l = FormulaBuilder.create(f.getLeft(), qValue, traceTu, signalMap, result);
        MtlFormula r = FormulaBuilder.create(f.getRight(), qValue, traceTu, signalMap, result);
        if (l instanceof StlFormula && r instanceof StlFormula) {
            return StlBuilder.IMPLY((StlFormula)((StlFormula)l), (StlFormula)((StlFormula)r));
        }
        return MtlBuilder.IMPLY((MtlFormula)l, (MtlFormula)r);
    }

    private static MtlFormula createNot(NotFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula f2 = FormulaBuilder.create(f.getFormula(), qValue, traceTu, signalMap, result);
        if (f2 instanceof StlFormula) {
            return StlBuilder.NOT((StlFormula)((StlFormula)f2));
        }
        return MtlBuilder.NOT((MtlFormula)f2);
    }

    private static MtlFormula createF0(FinallyUntimedFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula f2 = FormulaBuilder.create(f.getFormula(), qValue, traceTu, signalMap, result);
        if (f2 instanceof StlFormula) {
            return StlBuilder.F((StlFormula)((StlFormula)f2));
        }
        return MtlBuilder.F((MtlFormula)f2);
    }

    private static MtlFormula createF1(FinallyFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula f2 = FormulaBuilder.create(f.getFormula(), qValue, traceTu, signalMap, result);
        Interval i = FormulaHelper.from(traceTu, f.getInterval());
        if (f2 instanceof StlFormula) {
            return StlBuilder.F((StlFormula)((StlFormula)f2), (double)i.lb().doubleValue(), (double)i.ub().doubleValue());
        }
        return MtlBuilder.F((MtlFormula)f2, (Interval)i);
    }

    private static MtlFormula createG0(GloballyUntimedFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula f2 = FormulaBuilder.create(f.getFormula(), qValue, traceTu, signalMap, result);
        if (f2 instanceof StlFormula) {
            return StlBuilder.G((StlFormula)((StlFormula)f2));
        }
        return MtlBuilder.G((MtlFormula)f2);
    }

    private static MtlFormula createG1(GloballyFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula f2 = FormulaBuilder.create(f.getFormula(), qValue, traceTu, signalMap, result);
        Interval i = FormulaHelper.from(traceTu, f.getInterval());
        if (f2 instanceof StlFormula) {
            return StlBuilder.G((StlFormula)((StlFormula)f2), (double)i.lb().doubleValue(), (double)i.ub().doubleValue());
        }
        return MtlBuilder.G((MtlFormula)f2, (Interval)i);
    }

    private static MtlFormula createU0(UntilUntimedFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula left = FormulaBuilder.create(f.getLeft(), qValue, traceTu, signalMap, result);
        MtlFormula right = FormulaBuilder.create(f.getRight(), qValue, traceTu, signalMap, result);
        return MtlBuilder.U((MtlFormula)left, (MtlFormula)right, (Interval)new Interval((Number)0, false, (Number)Double.POSITIVE_INFINITY, true));
    }

    private static MtlFormula createU1(UntilFormula f, Integer qValue, TimeUnit traceTu, Map<String, IPsop> signalMap, VerificationResult result) throws FormulaBuilderException {
        MtlFormula left = FormulaBuilder.create(f.getLeft(), qValue, traceTu, signalMap, result);
        MtlFormula right = FormulaBuilder.create(f.getRight(), qValue, traceTu, signalMap, result);
        return MtlBuilder.U((MtlFormula)left, (MtlFormula)right, (Interval)FormulaHelper.from(traceTu, f.getInterval()));
    }
}

