/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.signal.impl;

public class LinearSignalFragment {
    private final double t0;
    private final double t1;
    private final double y0;
    private final double y1;

    public LinearSignalFragment(double t, double y) {
        this.t0 = t;
        this.t1 = t;
        this.y0 = y;
        this.y1 = y;
    }

    public LinearSignalFragment(double t0, double t1, double y) {
        if (t1 < t0 || t0 == t1) {
            throw new IllegalArgumentException();
        }
        this.t0 = t0;
        this.t1 = t1;
        this.y0 = y;
        this.y1 = y;
    }

    public LinearSignalFragment(double t0, double t1, double y0, double y1) {
        if (t1 < t0 || t0 == t1) {
            throw new IllegalArgumentException();
        }
        this.t0 = t0;
        this.t1 = t1;
        this.y0 = y0;
        this.y1 = y1;
    }

    public double getT0() {
        return this.t0;
    }

    public double getT1() {
        return this.t1;
    }

    public double getY0() {
        return this.y0;
    }

    public double getY1() {
        return this.y1;
    }

    public boolean isConstant() {
        return this.y0 == this.y1;
    }

    public boolean isInstantaneousEvent() {
        return this.t0 == this.t1;
    }

    public double getWidth() {
        return this.t1 - this.t0;
    }

    public double getCoefficient() {
        if (this.isInstantaneousEvent()) {
            throw new IllegalStateException("instantaneous fragment has no coefficient");
        }
        if (this.isConstant()) {
            return 0.0;
        }
        return (this.y1 - this.y0) / (this.t1 - this.t0);
    }

    public String toString() {
        return "LinearSignalFragment[t0=" + this.t0 + ", t1=" + this.t1 + ", y0=" + this.y0 + ", y1=" + this.y1 + "]";
    }
}

