/*
 * Decompiled with CFR 0.152.
 */
package samples.subsystems;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.filters.actions.SystemChangeFilterAction;
import org.eclipse.rse.ui.filters.actions.SystemNewFilterAction;
import org.eclipse.rse.ui.view.SubSystemConfigurationAdapter;
import org.eclipse.swt.widgets.Shell;
import samples.RSESamplesPlugin;
import samples.RSESamplesResources;
import samples.subsystems.DeveloperFilterStringEditPane;

public class DeveloperSubSystemConfigurationAdapter
extends SubSystemConfigurationAdapter {
    protected IAction[] getNewFilterPoolFilterActions(ISubSystemConfiguration factory, ISystemFilterPool selectedPool, Shell shell) {
        SystemNewFilterAction teamAction = (SystemNewFilterAction)super.getNewFilterPoolFilterAction(factory, selectedPool, shell);
        teamAction.setWizardPageTitle(RSESamplesResources.filter_team_pagetitle);
        teamAction.setPage1Description(RSESamplesResources.filter_team_pagetext);
        teamAction.setType("team");
        teamAction.setText(String.valueOf(RSESamplesResources.filter_team_pagetitle) + "...");
        SystemNewFilterAction devrAction = (SystemNewFilterAction)super.getNewFilterPoolFilterAction(factory, selectedPool, shell);
        devrAction.setWizardPageTitle(RSESamplesResources.filter_devr_pagetitle);
        devrAction.setPage1Description(RSESamplesResources.filter_devr_pagetext);
        devrAction.setType("devr");
        devrAction.setText(String.valueOf(RSESamplesResources.filter_devr_pagetitle) + "...");
        devrAction.setFilterStringEditPane((SystemFilterStringEditPane)new DeveloperFilterStringEditPane(shell));
        IAction[] actions = new IAction[]{teamAction, devrAction};
        return actions;
    }

    protected IAction getChangeFilterAction(ISubSystemConfiguration factory, ISystemFilter selectedFilter, Shell shell) {
        SystemChangeFilterAction action = (SystemChangeFilterAction)super.getChangeFilterAction(factory, selectedFilter, shell);
        String type = selectedFilter.getType();
        if (type == null) {
            type = "team";
        }
        if (type.equals("team")) {
            action.setDialogTitle(RSESamplesResources.filter_team_dlgtitle);
        } else {
            action.setDialogTitle(RSESamplesResources.filter_devr_dlgtitle);
            action.setFilterStringEditPane((SystemFilterStringEditPane)new DeveloperFilterStringEditPane(shell));
        }
        return action;
    }

    public ImageDescriptor getSystemFilterImage(ISystemFilter filter) {
        String type = filter.getType();
        if (type == null) {
            type = "team";
        }
        if (type.equals("team")) {
            return RSESamplesPlugin.getDefault().getImageDescriptor("ICON_ID_TEAMFILTER");
        }
        return RSESamplesPlugin.getDefault().getImageDescriptor("ICON_ID_DEVELOPERFILTER");
    }
}

