/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.serial.controls;

import gnu.io.CommPortIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.terminal.connector.serial.activator.UIPlugin;
import org.eclipse.tm.terminal.connector.serial.controls.SerialPortAddressDialog;
import org.eclipse.tm.terminal.connector.serial.nls.Messages;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.panels.AbstractConfigurationPanel;
import org.eclipse.ui.PlatformUI;

public class SerialLinePanel
extends AbstractConfigurationPanel {
    public static final String fcDefaultTTYSpeed = "9600";
    public static final String fcDefaultTTYDeviceWin32 = "COM1";
    public static final String fcDefaultTTYDeviceSolaris = "/dev/cua/a";
    public static final String fcDefaultTTYDeviceLinux = "/dev/ttyS0";
    public static final String fcDefaultTTYDatabits = "8";
    public static final String fcDefaultTTYParity = "None";
    public static final String fcDefaultTTYStopbits = "1";
    public static final String fcDefaultTTYFlowControl = "None";
    public static final String fcDefaultTTYTimeout = "5";
    public static final String fcEditableTTYOther = "Other...";
    private static final String[] fcTTYSpeedRates = new String[]{"600", "1200", "2400", "4800", "9600", "14400", "19200", "38400", "57600", "115200"};
    private static final String[] fcTTYDatabits = new String[]{"8", "7"};
    private static final String[] fcTTYParity = new String[]{"None", "Odd", "Even"};
    private static final String[] fcTTYStopbits = new String[]{"1", "2"};
    private static final String[] fcTTYFlowControl = new String[]{"None", "Hardware", "Software"};
    Label hostTTYDeviceLabel;
    Combo hostTTYDeviceCombo;
    Label hostTTYSpeedLabel;
    Combo hostTTYSpeedCombo;
    Label hostTTYBitsLabel;
    Combo hostTTYBitsCombo;
    Label hostTTYParityLabel;
    Combo hostTTYParityCombo;
    Label hostTTYStopbitsLabel;
    Combo hostTTYStopbitsCombo;
    Label hostTTYFlowControlLabel;
    Combo hostTTYFlowControlCombo;
    Label hostTTYTimeoutLabel;
    Text hostTTYTimeoutText;
    protected IInputValidator inputValidatorBaud;
    int lastSelected = -1;
    int lastSelectedBaud = -1;
    private final String fcSelectedTTYDeviceSlotId = "SerialLinePanel.selectedTTYDevice." + System.getProperty("os.name");
    private final String fcSelectedTTYSpeedRateSlotId = "SerialLinePanel.selectedTTYSpeedRate." + System.getProperty("os.name");
    private final String fcSelectedTTYDatabitsSlotId = "SerialLinePanel.selectedTTYDatabits." + System.getProperty("os.name");
    private final String fcSelectedTTYParitySlotId = "SerialLinePanel.selectedTTYParity." + System.getProperty("os.name");
    private final String fcSelectedTTYStopbitsSlotId = "SerialLinePanel.selectedTTYStopbits." + System.getProperty("os.name");
    private final String fcSelectedTTYFlowControlSlotId = "SerialLinePanel.selectedTTYFlowControl." + System.getProperty("os.name");
    private final String fcSelectedTTYTimeoutSlotId = "SerialLinePanel.selectedTTYTimeout." + System.getProperty("os.name");

    public SerialLinePanel(IConfigurationPanelContainer container) {
        super(container);
    }

    protected IInputValidator getCustomSerialBaudRateInputValidator() {
        if (this.inputValidatorBaud == null) {
            this.inputValidatorBaud = new CustomSerialBaudRateInputValidator();
        }
        return this.inputValidatorBaud;
    }

    public void setupPanel(Composite parent) {
        String element;
        Assert.isNotNull((Object)parent);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        panel.setBackground(parent.getBackground());
        this.setControl(panel);
        final Composite client = new Composite(parent, 0);
        Assert.isNotNull((Object)client);
        client.setLayout((Layout)new GridLayout(2, false));
        client.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        client.setBackground(panel.getBackground());
        this.hostTTYDeviceLabel = new Label(client, 0);
        this.hostTTYDeviceLabel.setText(Messages.SerialLinePanel_hostTTYDevice_label);
        this.hostTTYDeviceCombo = new Combo(client, 2060);
        this.hostTTYDeviceCombo.setLayoutData((Object)new GridData(768));
        this.hostTTYDeviceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SerialLinePanel.fcEditableTTYOther.equals(SerialLinePanel.this.hostTTYDeviceCombo.getText())) {
                    ArrayList<String> tty = new ArrayList<String>();
                    ArrayList<String> tcp = new ArrayList<String>();
                    String selected = SerialLinePanel.this.hostTTYDeviceCombo.getItem(SerialLinePanel.this.lastSelected);
                    String[] stringArray = SerialLinePanel.this.hostTTYDeviceCombo.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String device = stringArray[n2];
                        if (!device.equalsIgnoreCase(SerialLinePanel.fcEditableTTYOther)) {
                            if (device.toUpperCase().startsWith("TCP:")) {
                                tcp.add(device);
                            } else {
                                tty.add(device);
                            }
                        }
                        ++n2;
                    }
                    SerialPortAddressDialog dialog = new SerialPortAddressDialog(client.getShell(), selected, tty, tcp);
                    if (dialog.open() == 0) {
                        String device = dialog.getData();
                        if (device != null && device.trim().length() > 0) {
                            SerialLinePanel.this.hostTTYDeviceCombo.add(device.trim());
                            SerialLinePanel.this.hostTTYDeviceCombo.setText(device.trim());
                        } else if (SerialLinePanel.this.lastSelected != -1) {
                            SerialLinePanel.this.hostTTYDeviceCombo.setText(SerialLinePanel.this.hostTTYDeviceCombo.getItem(SerialLinePanel.this.lastSelected));
                        }
                    } else if (SerialLinePanel.this.lastSelected != -1) {
                        SerialLinePanel.this.hostTTYDeviceCombo.setText(SerialLinePanel.this.hostTTYDeviceCombo.getItem(SerialLinePanel.this.lastSelected));
                    }
                }
                SerialLinePanel.this.lastSelected = SerialLinePanel.this.hostTTYDeviceCombo.getSelectionIndex();
                IConfigurationPanelContainer container = SerialLinePanel.this.getContainer();
                if (container != null) {
                    container.validate();
                }
            }
        });
        this.hostTTYSpeedLabel = new Label(client, 0);
        this.hostTTYSpeedLabel.setText(Messages.SerialLinePanel_hostTTYSpeed_label);
        this.hostTTYSpeedCombo = new Combo(client, 2060);
        this.hostTTYSpeedCombo.setLayoutData((Object)new GridData(768));
        this.hostTTYSpeedCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SerialLinePanel.fcEditableTTYOther.equals(SerialLinePanel.this.hostTTYSpeedCombo.getText())) {
                    InputDialog dialog = new InputDialog(SerialLinePanel.this.getControl().getShell(), Messages.SerialLinePanel_customSerialBaudRate_title, Messages.SerialLinePanel_customSerialBaudRate_message, "", SerialLinePanel.this.getCustomSerialBaudRateInputValidator());
                    if (dialog.open() == 0) {
                        String device = dialog.getValue();
                        if (device != null && device.trim().length() > 0) {
                            int index = SerialLinePanel.this.hostTTYSpeedCombo.indexOf(SerialLinePanel.fcEditableTTYOther);
                            if (index != -1 && index == SerialLinePanel.this.hostTTYSpeedCombo.getItemCount() - 1) {
                                SerialLinePanel.this.hostTTYSpeedCombo.add(device.trim());
                            } else if (index != -1) {
                                SerialLinePanel.this.hostTTYSpeedCombo.setItem(index + 1, device.trim());
                            }
                            SerialLinePanel.this.hostTTYSpeedCombo.setText(device.trim());
                        } else if (SerialLinePanel.this.lastSelectedBaud != -1) {
                            SerialLinePanel.this.hostTTYSpeedCombo.setText(SerialLinePanel.this.hostTTYSpeedCombo.getItem(SerialLinePanel.this.lastSelectedBaud));
                        }
                    } else if (SerialLinePanel.this.lastSelectedBaud != -1) {
                        SerialLinePanel.this.hostTTYSpeedCombo.setText(SerialLinePanel.this.hostTTYSpeedCombo.getItem(SerialLinePanel.this.lastSelectedBaud));
                    }
                }
                SerialLinePanel.this.lastSelectedBaud = SerialLinePanel.this.hostTTYSpeedCombo.getSelectionIndex();
                IConfigurationPanelContainer container = SerialLinePanel.this.getContainer();
                if (container != null) {
                    container.validate();
                }
            }
        });
        UIPlugin.getTraceHandler().trace("SerialLinePanel: Start quering the available comm ports.", "trace/serialLinePanel", (Object)this);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SerialLinePanel.this.queryAvailableSerialDevices();
            }
        });
        this.hostTTYDeviceCombo.add(fcEditableTTYOther);
        if (this.hostTTYDeviceCombo.indexOf(this.getDefaultHostTTYDevice()) != -1) {
            this.hostTTYDeviceCombo.setText(this.getDefaultHostTTYDevice());
        } else if ("".equals(this.hostTTYDeviceCombo.getText()) && this.hostTTYDeviceCombo.getItemCount() > 0) {
            if (this.hostTTYDeviceCombo.getItemCount() == 1 && fcEditableTTYOther.equals(this.hostTTYDeviceCombo.getItem(0))) {
                this.hostTTYDeviceCombo.add("", 0);
            }
            this.hostTTYDeviceCombo.setText(this.hostTTYDeviceCombo.getItem(0));
        }
        if (this.hostTTYDeviceCombo.getItemCount() > 0) {
            this.hostTTYDeviceCombo.setEnabled(true);
        } else {
            this.hostTTYDeviceCombo.setEnabled(false);
        }
        this.lastSelected = this.hostTTYDeviceCombo.getSelectionIndex();
        String[] stringArray = fcTTYSpeedRates;
        int n = fcTTYSpeedRates.length;
        int n2 = 0;
        while (n2 < n) {
            String fcTTYSpeedRate = stringArray[n2];
            this.hostTTYSpeedCombo.add(fcTTYSpeedRate);
            ++n2;
        }
        this.hostTTYSpeedCombo.add(fcEditableTTYOther);
        this.hostTTYSpeedCombo.setText(fcDefaultTTYSpeed);
        this.lastSelectedBaud = this.hostTTYSpeedCombo.getSelectionIndex();
        this.hostTTYBitsLabel = new Label(client, 0);
        this.hostTTYBitsLabel.setText(Messages.SerialLinePanel_hostTTYDatabits_label);
        this.hostTTYBitsCombo = new Combo(client, 2060);
        this.hostTTYBitsCombo.setLayoutData((Object)new GridData(768));
        this.hostTTYBitsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConfigurationPanelContainer container = SerialLinePanel.this.getContainer();
                if (container != null) {
                    container.validate();
                }
            }
        });
        stringArray = fcTTYDatabits;
        n = fcTTYDatabits.length;
        n2 = 0;
        while (n2 < n) {
            String fcTTYDatabit = stringArray[n2];
            this.hostTTYBitsCombo.add(fcTTYDatabit);
            ++n2;
        }
        this.hostTTYBitsCombo.setText(fcDefaultTTYDatabits);
        this.hostTTYParityLabel = new Label(client, 0);
        this.hostTTYParityLabel.setText(Messages.SerialLinePanel_hostTTYParity_label);
        this.hostTTYParityCombo = new Combo(client, 2060);
        this.hostTTYParityCombo.setLayoutData((Object)new GridData(768));
        this.hostTTYParityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConfigurationPanelContainer container = SerialLinePanel.this.getContainer();
                if (container != null) {
                    container.validate();
                }
            }
        });
        stringArray = fcTTYParity;
        n = fcTTYParity.length;
        n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            this.hostTTYParityCombo.add(element);
            ++n2;
        }
        this.hostTTYParityCombo.setText("None");
        this.hostTTYStopbitsLabel = new Label(client, 0);
        this.hostTTYStopbitsLabel.setText(Messages.SerialLinePanel_hostTTYStopbits_label);
        this.hostTTYStopbitsCombo = new Combo(client, 2060);
        this.hostTTYStopbitsCombo.setLayoutData((Object)new GridData(768));
        this.hostTTYStopbitsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConfigurationPanelContainer container = SerialLinePanel.this.getContainer();
                if (container != null) {
                    container.validate();
                }
            }
        });
        stringArray = fcTTYStopbits;
        n = fcTTYStopbits.length;
        n2 = 0;
        while (n2 < n) {
            String fcTTYStopbit = stringArray[n2];
            this.hostTTYStopbitsCombo.add(fcTTYStopbit);
            ++n2;
        }
        this.hostTTYStopbitsCombo.setText(fcDefaultTTYStopbits);
        this.hostTTYFlowControlLabel = new Label(client, 0);
        this.hostTTYFlowControlLabel.setText(Messages.SerialLinePanel_hostTTYFlowControl_label);
        this.hostTTYFlowControlCombo = new Combo(client, 2060);
        this.hostTTYFlowControlCombo.setLayoutData((Object)new GridData(768));
        this.hostTTYFlowControlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IConfigurationPanelContainer container = SerialLinePanel.this.getContainer();
                if (container != null) {
                    container.validate();
                }
            }
        });
        stringArray = fcTTYFlowControl;
        n = fcTTYFlowControl.length;
        n2 = 0;
        while (n2 < n) {
            element = stringArray[n2];
            this.hostTTYFlowControlCombo.add(element);
            ++n2;
        }
        this.hostTTYFlowControlCombo.setText("None");
        this.hostTTYTimeoutLabel = new Label(client, 0);
        this.hostTTYTimeoutLabel.setText(Messages.SerialLinePanel_hostTTYTimeout_label);
        this.hostTTYTimeoutText = new Text(client, 2052);
        this.hostTTYTimeoutText.setLayoutData((Object)new GridData(768));
        this.hostTTYTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IConfigurationPanelContainer container = SerialLinePanel.this.getContainer();
                if (container != null) {
                    container.validate();
                }
            }
        });
        this.hostTTYTimeoutText.setText(fcDefaultTTYTimeout);
    }

    protected void queryAvailableSerialDevices() {
        String prop = System.getProperty("gnu.io.rxtx.NoVersionOutput");
        if (prop == null && !Platform.inDebugMode()) {
            System.setProperty("gnu.io.rxtx.NoVersionOutput", "true");
        }
        try {
            Enumeration ttyPortIds = CommPortIdentifier.getPortIdentifiers();
            if (!ttyPortIds.hasMoreElements()) {
                UIPlugin.getTraceHandler().trace("SerialLinePanel: NO comm ports available at all!", "trace/serialLinePanel", (Object)this);
            }
            final ArrayList<String> ports = new ArrayList<String>();
            while (ttyPortIds.hasMoreElements()) {
                CommPortIdentifier port = (CommPortIdentifier)ttyPortIds.nextElement();
                String type = "unknown";
                if (port.getPortType() == 2) {
                    type = "parallel";
                }
                if (port.getPortType() == 1) {
                    type = "serial";
                }
                UIPlugin.getTraceHandler().trace("SerialLinePanel: Found comm port: name='" + port.getName() + "', type='" + type, "trace/serialLinePanel", (Object)this);
                if (port.getPortType() != 1) continue;
                UIPlugin.getTraceHandler().trace("SerialLinePanel: Adding found serial comm port to combo!", "trace/serialLinePanel", (Object)this);
                if (ports.contains(port.getName())) continue;
                ports.add(port.getName());
            }
            if (!ports.isEmpty()) {
                Collections.sort(ports);
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (String port : ports) {
                            SerialLinePanel.this.hostTTYDeviceCombo.add(port);
                        }
                    }
                });
            }
        }
        catch (UnsatisfiedLinkError e) {
            Status status = new Status(2, UIPlugin.getUniqueIdentifier(), Messages.SerialLinePanel_warning_FailedToLoadSerialPorts, (Throwable)e);
            UIPlugin.getDefault().getLog().log((IStatus)status);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    public void setEnabled(boolean enabled) {
        this.hostTTYDeviceLabel.setEnabled(enabled);
        this.hostTTYDeviceCombo.setEnabled(enabled);
        this.hostTTYSpeedLabel.setEnabled(enabled);
        this.hostTTYSpeedCombo.setEnabled(enabled);
        this.hostTTYBitsLabel.setEnabled(enabled);
        this.hostTTYBitsCombo.setEnabled(enabled);
        this.hostTTYParityLabel.setEnabled(enabled);
        this.hostTTYParityCombo.setEnabled(enabled);
        this.hostTTYStopbitsLabel.setEnabled(enabled);
        this.hostTTYStopbitsCombo.setEnabled(enabled);
        this.hostTTYFlowControlLabel.setEnabled(enabled);
        this.hostTTYFlowControlCombo.setEnabled(enabled);
    }

    public String getDefaultHostTTYDevice() {
        String osName = System.getProperty("os.name");
        if (osName.equalsIgnoreCase("Linux")) {
            return fcDefaultTTYDeviceLinux;
        }
        if (osName.equalsIgnoreCase("SunOS")) {
            return fcDefaultTTYDeviceSolaris;
        }
        if (osName.toLowerCase().startsWith("windows")) {
            return fcDefaultTTYDeviceWin32;
        }
        return "";
    }

    public String getDefaultHostTTYSpeed() {
        return fcDefaultTTYSpeed;
    }

    public String getDefaultHostTTYDatabits() {
        return fcDefaultTTYDatabits;
    }

    public String getDefaultHostTTYParity() {
        return "None";
    }

    public String getDefaultHostTTYStopbits() {
        return fcDefaultTTYStopbits;
    }

    public String getDefaultHostTTYFlowControl() {
        return "None";
    }

    public String getDefaultHostTTYTimeout() {
        return fcDefaultTTYTimeout;
    }

    protected void doSetTextInCombo(Combo combo, String value) {
        Assert.isNotNull((Object)combo);
        Assert.isNotNull((Object)value);
        if (combo.indexOf(value) != 1) {
            combo.setText(value);
        }
    }

    public void setSelectedTTYDevice(String value) {
        this.doSetTextInCombo(this.hostTTYDeviceCombo, value);
    }

    public void setSelectedTTYDevice(int index) {
        if (index >= 0 && index < this.hostTTYDeviceCombo.getItemCount()) {
            this.hostTTYDeviceCombo.setText(this.hostTTYDeviceCombo.getItem(index));
        }
    }

    public void setSelectedTTYSpeed(String value) {
        this.doSetTextInCombo(this.hostTTYSpeedCombo, value);
    }

    public void setSelectedTTYDatabits(String value) {
        this.doSetTextInCombo(this.hostTTYBitsCombo, value);
    }

    public void setSelectedTTYParity(String value) {
        this.doSetTextInCombo(this.hostTTYParityCombo, value);
    }

    public void setSelectedTTYStopbits(String value) {
        this.doSetTextInCombo(this.hostTTYStopbitsCombo, value);
    }

    public void setSelectedTTYFlowControl(String value) {
        this.doSetTextInCombo(this.hostTTYFlowControlCombo, value);
    }

    public boolean isValid() {
        String selectedTTYDevice = this.hostTTYDeviceCombo.getText();
        if (selectedTTYDevice == null || selectedTTYDevice.trim().length() == 0) {
            this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYDevice, 3);
            return false;
        }
        if (fcEditableTTYOther.equals(selectedTTYDevice)) {
            this.setMessage(Messages.SerialLinePanel_info_editableTTYDeviceSelected, 1);
            return false;
        }
        String selectedTTYSpeedRate = this.hostTTYSpeedCombo.getText();
        if (selectedTTYSpeedRate == null || selectedTTYSpeedRate.trim().length() == 0) {
            this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYSpeedRate, 3);
            return false;
        }
        if (fcEditableTTYOther.equals(selectedTTYSpeedRate)) {
            this.setMessage(Messages.SerialLinePanel_info_editableTTYBaudRateSelected, 1);
            return false;
        }
        String option = this.hostTTYBitsCombo.getText();
        if (option == null || option.trim().length() == 0) {
            this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYDatabits, 3);
            return false;
        }
        option = this.hostTTYParityCombo.getText();
        if (option == null || option.trim().length() == 0) {
            this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYParity, 3);
            return false;
        }
        option = this.hostTTYStopbitsCombo.getText();
        if (option == null || option.trim().length() == 0) {
            this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYStopbits, 3);
            return false;
        }
        option = this.hostTTYFlowControlCombo.getText();
        if (option == null || option.trim().length() == 0) {
            this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYFlowControl, 3);
            return false;
        }
        option = this.hostTTYTimeoutText.getText();
        if (option == null || option.trim().length() == 0) {
            this.setMessage(Messages.SerialLinePanel_error_emptyHostTTYFlowControl, 3);
            return false;
        }
        return true;
    }

    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        String option;
        String selectedTTYSpeedRate;
        Assert.isNotNull((Object)settings);
        String selectedTTYDevice = settings.get(this.prefixDialogSettingsSlotId(this.fcSelectedTTYDeviceSlotId, idPrefix));
        if (selectedTTYDevice != null && selectedTTYDevice.trim().length() > 0 && this.hostTTYDeviceCombo.indexOf(selectedTTYDevice) != -1) {
            this.hostTTYDeviceCombo.setText(selectedTTYDevice);
        }
        if ((selectedTTYSpeedRate = settings.get(this.prefixDialogSettingsSlotId(this.fcSelectedTTYSpeedRateSlotId, idPrefix))) != null && selectedTTYSpeedRate.trim().length() > 0 && this.hostTTYSpeedCombo.indexOf(selectedTTYSpeedRate) != -1) {
            this.hostTTYSpeedCombo.setText(selectedTTYSpeedRate);
        }
        if ((option = settings.get(this.prefixDialogSettingsSlotId(this.fcSelectedTTYDatabitsSlotId, idPrefix))) != null && option.trim().length() > 0 && this.hostTTYBitsCombo.indexOf(option) != -1) {
            this.hostTTYBitsCombo.setText(option);
        }
        if ((option = settings.get(this.prefixDialogSettingsSlotId(this.fcSelectedTTYParitySlotId, idPrefix))) != null && option.trim().length() > 0 && this.hostTTYParityCombo.indexOf(option) != -1) {
            this.hostTTYParityCombo.setText(option);
        }
        if ((option = settings.get(this.prefixDialogSettingsSlotId(this.fcSelectedTTYStopbitsSlotId, idPrefix))) != null && option.trim().length() > 0 && this.hostTTYStopbitsCombo.indexOf(option) != -1) {
            this.hostTTYStopbitsCombo.setText(option);
        }
        if ((option = settings.get(this.prefixDialogSettingsSlotId(this.fcSelectedTTYFlowControlSlotId, idPrefix))) != null && option.trim().length() > 0 && this.hostTTYFlowControlCombo.indexOf(option) != -1) {
            this.hostTTYFlowControlCombo.setText(option);
        }
        if ((option = settings.get(this.prefixDialogSettingsSlotId(this.fcSelectedTTYTimeoutSlotId, idPrefix))) != null && option.trim().length() > 0 && !option.equals(this.hostTTYTimeoutText.getText())) {
            this.hostTTYTimeoutText.setText(option);
        }
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        settings.put(this.prefixDialogSettingsSlotId(this.fcSelectedTTYDeviceSlotId, idPrefix), this.hostTTYDeviceCombo.getText());
        settings.put(this.prefixDialogSettingsSlotId(this.fcSelectedTTYSpeedRateSlotId, idPrefix), this.hostTTYSpeedCombo.getText());
        settings.put(this.prefixDialogSettingsSlotId(this.fcSelectedTTYDatabitsSlotId, idPrefix), this.hostTTYBitsCombo.getText());
        settings.put(this.prefixDialogSettingsSlotId(this.fcSelectedTTYParitySlotId, idPrefix), this.hostTTYParityCombo.getText());
        settings.put(this.prefixDialogSettingsSlotId(this.fcSelectedTTYStopbitsSlotId, idPrefix), this.hostTTYStopbitsCombo.getText());
        settings.put(this.prefixDialogSettingsSlotId(this.fcSelectedTTYFlowControlSlotId, idPrefix), this.hostTTYFlowControlCombo.getText());
        settings.put(this.prefixDialogSettingsSlotId(this.fcSelectedTTYTimeoutSlotId, idPrefix), this.hostTTYTimeoutText.getText());
    }

    public void setupData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        this.hostTTYDeviceCombo.setText((String)data.get("serial.device"));
        this.hostTTYSpeedCombo.setText((String)data.get("serial.baudrate"));
        this.hostTTYBitsCombo.setText((String)data.get("serial.databits"));
        this.hostTTYParityCombo.setText((String)data.get("serial.parity"));
        this.hostTTYStopbitsCombo.setText((String)data.get("serial.stopbits"));
        this.hostTTYFlowControlCombo.setText((String)data.get("serial.flowcontrol"));
        Object value = data.get("timeout");
        if (value instanceof Integer) {
            this.hostTTYTimeoutText.setText(((Integer)value).toString());
        }
    }

    public void extractData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        data.put("serial.device", this.hostTTYDeviceCombo.getText());
        data.put("serial.baudrate", this.hostTTYSpeedCombo.getText());
        data.put("serial.databits", this.hostTTYBitsCombo.getText());
        data.put("serial.parity", this.hostTTYParityCombo.getText());
        data.put("serial.stopbits", this.hostTTYStopbitsCombo.getText());
        data.put("serial.flowcontrol", this.hostTTYFlowControlCombo.getText());
        if (this.hostTTYTimeoutText.getText() != null) {
            Integer timeout = null;
            try {
                timeout = Integer.decode(this.hostTTYTimeoutText.getText());
            }
            catch (NumberFormatException numberFormatException) {}
            if (timeout != null) {
                data.put("timeout", timeout);
            } else {
                data.remove("timeout");
            }
        }
    }

    protected class CustomSerialBaudRateInputValidator
    implements IInputValidator {
        protected CustomSerialBaudRateInputValidator() {
        }

        public String isValid(String newText) {
            if (newText != null && newText.trim().length() > 0) {
                if (!newText.matches("[0-9]*")) {
                    return Messages.SerialLinePanel_error_invalidCharactesBaudRate;
                }
            } else if (newText != null) {
                return "";
            }
            return null;
        }
    }
}

