/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.jni;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.executor.TITANConsole;
import org.eclipse.titan.executor.jni.ComponentStruct;
import org.eclipse.titan.executor.jni.HcStateEnum;
import org.eclipse.titan.executor.jni.HostStruct;
import org.eclipse.titan.executor.jni.IJNICallback;
import org.eclipse.titan.executor.jni.McStateEnum;
import org.eclipse.titan.executor.jni.TcStateEnum;
import org.eclipse.titan.executor.jni.TransportTypeEnum;
import org.eclipse.titan.runtime.core.mctr.Timeval;

public final class JNIMiddleWare {
    private static final String STATUSCHANGE_INDICATOR = "S";
    private static final String ERRORCALLBACK_INDICATOR = "E";
    private static final String NOTIFICATION_INDICATOR = "N";
    private static Exception exception = null;
    private Thread eTh;
    private IJNICallback jniCallback;
    private volatile long userinterface_ptr = -1L;

    public JNIMiddleWare(IJNICallback jniCallback) {
        this.jniCallback = jniCallback;
    }

    public static Exception getException() {
        return exception;
    }

    private native long init(int var1);

    public native void terminate();

    public native void add_host(String var1, String var2);

    public native void assign_component(String var1, String var2);

    public native void destroy_host_groups();

    public native void set_kill_timer(double var1);

    public native int start_session(String var1, int var2, boolean var3);

    public native void shutdown_session();

    public native void configure(String var1);

    public native void create_mtc(int var1);

    public native void exit_mtc();

    public native void execute_control(String var1);

    public native void execute_testcase(String var1, String var2);

    public native void stop_after_testcase(boolean var1);

    public native void continue_testcase();

    public native void stop_execution();

    public native McStateEnum get_state();

    public native boolean get_stop_after_testcase();

    public native int get_nof_hosts();

    public native HostStruct get_host_data(int var1);

    public native ComponentStruct get_component_data(int var1);

    public native void release_data();

    public native String get_mc_state_name(McStateEnum var1);

    public native String get_hc_state_name(HcStateEnum var1);

    public native String get_tc_state_name(TcStateEnum var1);

    public native String get_transport_name(TransportTypeEnum var1);

    public native void check_mem_leak(String var1);

    public native void print_license_info();

    public native int check_license();

    public native String readPipe();

    public native boolean isPipeReadable();

    public static native long getSharedLibraryVersion();

    public void initialize(int par_max_ptcs) {
        if (this.userinterface_ptr == -1L) {
            this.userinterface_ptr = this.init(par_max_ptcs);
            this.eTh = new Thread(new EventDispatcher());
            this.eTh.start();
        } else {
            TITANConsole.println("Main Controller has been already initialized!");
        }
    }

    public void terminate_internal() {
        this.userinterface_ptr = -1L;
        this.terminate();
    }

    private List<String> splitPacket(String s) {
        String pdu = s.substring(6);
        ArrayList<String> stringList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int length = pdu.length();
        int i = 0;
        block4: while (i < length) {
            char ch = pdu.charAt(i);
            switch (ch) {
                case '|': {
                    stringList.add(sb.toString());
                    sb = new StringBuilder();
                    ++i;
                    continue block4;
                }
                case '\\': {
                    sb.append(pdu.charAt(i + 1));
                    i += 2;
                    continue block4;
                }
            }
            sb.append(ch);
            ++i;
        }
        stringList.add(sb.toString());
        return stringList;
    }

    private void processStatusChangeCallback() {
        this.jniCallback.statusChangeCallback();
    }

    private void processErrorCallbackFast(String s) {
        String[] tempArray = new String[1];
        String[] ppdu = this.splitPacket(s).toArray(tempArray);
        this.jniCallback.insertError(Integer.parseInt(ppdu[0]), ppdu[1]);
    }

    private void processErrorCallback(String s) {
        String[] tempArray = new String[1];
        String[] ppdu = this.splitPacket(s).toArray(tempArray);
        this.jniCallback.errorCallback(Integer.parseInt(ppdu[0]), ppdu[1]);
    }

    public void batchedProcessNotifications(ArrayList<String> s) {
        String[] tempArray = new String[1];
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (String value : s) {
            result.add(this.splitPacket(value).toArray(tempArray));
        }
        this.jniCallback.batchedInsertNotify(result);
    }

    public void processNotifyCallbackFast(String s) {
        String[] tempArray = new String[1];
        String[] ppdu = this.splitPacket(s).toArray(tempArray);
        this.jniCallback.insertNotify(new Timeval((long)Integer.parseInt(ppdu[0]), (long)Integer.parseInt(ppdu[1])), ppdu[2], Integer.parseInt(ppdu[3]), ppdu[4]);
    }

    public void processNotifyCallback(String s) {
        String[] tempArray = new String[1];
        String[] ppdu = this.splitPacket(s).toArray(tempArray);
        this.jniCallback.notifyCallback(new Timeval((long)Integer.parseInt(ppdu[0]), (long)Integer.parseInt(ppdu[1])), ppdu[2], Integer.parseInt(ppdu[3]), ppdu[4]);
    }

    static {
        if ("win32".equals(Platform.getOS())) {
            exception = new Exception("Execution in JNI mode is not supported on the Windows operating system.");
        } else {
            try {
                System.loadLibrary("mctrjninative");
            }
            catch (SecurityException e) {
                exception = new Exception("Security manager does not allow loading of the JNI dinamic library.");
                exception.setStackTrace(e.getStackTrace());
            }
            catch (UnsatisfiedLinkError e) {
                exception = new Exception("JNI dynamic library could not be loaded.\n\noriginal message: " + e.getMessage() + "\n\njava.library.path = " + System.getProperty("java.library.path"));
                exception.setStackTrace(e.getStackTrace());
            }
        }
    }

    private final class EventDispatcher
    implements Runnable {
        private EventDispatcher() {
        }

        @Override
        public void run() {
            while (JNIMiddleWare.this.userinterface_ptr != -1L) {
                String s = JNIMiddleWare.this.readPipe();
                if (s.startsWith(JNIMiddleWare.STATUSCHANGE_INDICATOR)) {
                    ArrayList<String> notifications = new ArrayList<String>();
                    while (JNIMiddleWare.this.isPipeReadable()) {
                        String s2 = JNIMiddleWare.this.readPipe();
                        if (s2.startsWith(JNIMiddleWare.ERRORCALLBACK_INDICATOR)) {
                            JNIMiddleWare.this.processErrorCallbackFast(s2);
                            continue;
                        }
                        if (!s2.startsWith(JNIMiddleWare.NOTIFICATION_INDICATOR)) break;
                        notifications.add(s2);
                    }
                    JNIMiddleWare.this.batchedProcessNotifications(notifications);
                    notifications.clear();
                    JNIMiddleWare.this.processStatusChangeCallback();
                    continue;
                }
                if (s.startsWith(JNIMiddleWare.ERRORCALLBACK_INDICATOR)) {
                    JNIMiddleWare.this.processErrorCallback(s);
                    continue;
                }
                if (!s.startsWith(JNIMiddleWare.NOTIFICATION_INDICATOR)) continue;
                JNIMiddleWare.this.processNotifyCallback(s);
            }
        }
    }
}

