/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors.mctr.cli;

import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.executors.mctr.cli.CliExecutor;

public final class BackgroundThread
extends Thread {
    private boolean restarted = false;
    private boolean active = true;
    private final CliExecutor executor;
    private final int delay;
    private final Object lock = new Object();

    public BackgroundThread(String name, int delay, CliExecutor executor) {
        super(name);
        this.setPriority(1);
        this.setDaemon(true);
        this.delay = delay * 1000;
        this.executor = executor;
    }

    public void cancel() {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this;
        synchronized (object) {
            this.restarted = true;
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.active) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(this.delay);
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
            }
            object = this;
            synchronized (object) {
                if (this.restarted) {
                    this.restarted = false;
                    continue;
                }
            }
            if (null == this.executor) continue;
            if (this.executor.isTerminated()) {
                this.active = false;
                continue;
            }
            this.executor.info();
        }
    }
}

