/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.cfgparser;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.core.cfgparser.CFGListener;
import org.eclipse.titan.runtime.core.cfgparser.IOUtils;
import org.eclipse.titan.runtime.core.cfgparser.RuntimeCfgLexer;
import org.eclipse.titan.runtime.core.cfgparser.RuntimeCfgParser;

public class StringToTTCNAnalyzer {
    public static final int LEXER_MODE = 9;
    public static final String UNKNOWN_FILE = "<unknown file>";
    private Param_Types.Module_Parameter parsed_module_param;

    public Param_Types.Module_Parameter getParsedModuleParam() {
        return this.parsed_module_param;
    }

    public static Param_Types.Module_Parameter process_config_string2ttcn(String mp_str, boolean is_component) {
        StringToTTCNAnalyzer analyzer = new StringToTTCNAnalyzer();
        analyzer.parse(mp_str);
        if (analyzer.getParsedModuleParam() != null) {
            return analyzer.getParsedModuleParam();
        }
        throw new TtcnError("Internal error: could not parse TTCN string.");
    }

    public boolean parse(String code) {
        if (code == null || code.isEmpty()) {
            throw new TtcnError("StringToTTCNAnalyzer.parse(): nothing to parse");
        }
        StringReader reader = new StringReader(code);
        CFGListener lexerListener = new CFGListener(UNKNOWN_FILE);
        CommonTokenStream tokenStream = this.createTokeStream(reader, lexerListener);
        RuntimeCfgParser parser = new RuntimeCfgParser((TokenStream)tokenStream);
        parser.setBuildParseTree(true);
        try {
            this.parsed_module_param = parser.pr_ParameterValue().moduleparameter;
        }
        catch (Exception e) {
            throw new TtcnError(e.getMessage());
        }
        IOUtils.closeQuietly((Closeable)reader);
        return lexerListener.encounteredError();
    }

    private RuntimeCfgLexer createLexer(Reader reader, CFGListener lexerListener) {
        UnbufferedCharStream charStream = new UnbufferedCharStream(reader);
        RuntimeCfgLexer lexer = new RuntimeCfgLexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.mode(9);
        if (lexerListener != null) {
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)lexerListener);
        }
        return lexer;
    }

    private CommonTokenStream createTokeStream(Reader reader, CFGListener lexerListener) {
        RuntimeCfgLexer lexer = this.createLexer(reader, lexerListener);
        return new CommonTokenStream((TokenSource)lexer);
    }
}

