/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.generators;

import edu.uci.ics.jung.graph.util.EdgeType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportation;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.error.ErrorHandler;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.generators.GraphGenerator;

public class ModuleGraphGenerator
extends GraphGenerator {
    public ModuleGraphGenerator(IProject project, ErrorHandler eHandler) {
        super(project, eHandler);
        if (eHandler == null) {
            this.errorHandler.reportErrorMessage("The referenced error handler mustn't be null (source: ModuleGraphGenerator)");
        }
    }

    @Override
    protected void createGraph() {
        Module module;
        ArrayList<Module> modules;
        Set knownModuleNames;
        ProjectSourceParser projectSourceParser;
        IProject currentProject;
        int i;
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)this.project);
        if (sourceParser.getLastTimeChecked() == null) {
            WorkspaceJob job = sourceParser.analyzeAll();
            while (job == null) {
                try {
                    Thread.sleep(500L);
                    job = sourceParser.analyzeAll();
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((String)"Error while waiting for analyzis result", (Throwable)e);
                }
            }
            try {
                job.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((String)"Error while parsing the project", (Throwable)e);
            }
        }
        List visitedProjects = ProjectBasedBuilder.getProjectBasedBuilder((IProject)this.project).getAllReachableProjects();
        HashMap globalKnownModules = new HashMap();
        HashMap<String, Identifier> globalKnownModules2 = new HashMap<String, Identifier>();
        for (i = 0; i < visitedProjects.size(); ++i) {
            currentProject = (IProject)visitedProjects.get(i);
            projectSourceParser = GlobalParser.getProjectSourceParser((IProject)currentProject);
            knownModuleNames = projectSourceParser.getKnownModuleNames();
            modules = new ArrayList<Module>();
            for (String moduleName : new TreeSet(knownModuleNames)) {
                module = projectSourceParser.getModuleByName(moduleName);
                modules.add(module);
                Identifier moduleID = module.getIdentifier();
                globalKnownModules2.put(moduleName, moduleID);
                NodeDescriptor actNode = new NodeDescriptor(moduleID.getDisplayName(), moduleID.getName(), currentProject, false, moduleID.getLocation());
                if (this.graph.containsVertex((Object)actNode)) continue;
                this.graph.addVertex((Object)actNode);
                this.labels.put(actNode.getName(), actNode);
            }
        }
        for (i = 0; i < visitedProjects.size(); ++i) {
            currentProject = (IProject)visitedProjects.get(i);
            projectSourceParser = GlobalParser.getProjectSourceParser((IProject)currentProject);
            knownModuleNames = projectSourceParser.getKnownModuleNames();
            modules = new ArrayList();
            for (String moduleName : new TreeSet(knownModuleNames)) {
                module = projectSourceParser.getModuleByName(moduleName);
                modules.add(module);
            }
            for (Module module2 : modules) {
                ModuleImportsCheck importsCheck = new ModuleImportsCheck();
                module2.accept((ASTVisitor)importsCheck);
                for (ModuleImportation im : importsCheck.getImports()) {
                    NodeDescriptor actNode;
                    Identifier importIdentifier = im.getIdentifier();
                    if (!globalKnownModules.containsKey(importIdentifier.getName()) && !this.graph.containsVertex((Object)(actNode = new NodeDescriptor(importIdentifier.getDisplayName(), importIdentifier.getName(), currentProject, true, importIdentifier.getLocation())))) {
                        this.graph.addVertex((Object)actNode);
                        this.labels.put(actNode.getName(), actNode);
                    }
                    String from = module2.getIdentifier().getName();
                    String to = importIdentifier.getName();
                    EdgeDescriptor edge = new EdgeDescriptor(from + "->" + to, Color.black);
                    this.graph.addEdge((Object)edge, (Object)((NodeDescriptor)this.labels.get(from)), (Object)((NodeDescriptor)this.labels.get(to)), EdgeType.DIRECTED);
                }
            }
        }
    }

    class ModuleImportsCheck
    extends ASTVisitor {
        private final Set<ModuleImportation> setOfModules = new HashSet<ModuleImportation>();

        public ModuleImportsCheck() {
            this.setOfModules.clear();
        }

        public Set<ModuleImportation> getImports() {
            return this.setOfModules;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof ModuleImportation) {
                ModuleImportation mod = (ModuleImportation)node;
                this.setOfModules.add(mod);
                return 1;
            }
            if (node instanceof Assignment) {
                return 1;
            }
            return 3;
        }
    }
}

