/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.modulepar;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_ModulePar;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Port;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FriendModule;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public class DependencyCollector {
    private static final String MODULE_HEADER = "\n//Generated by Titanium->Extract modulepar\n\nmodule {0} \n'{'\n";
    private static final String MODULE_TRAILER = "\n\n}\n";
    private static final String DOUBLE_SEPARATOR = "\n\n";
    private static final String SINGLE_SEPARATOR = "\n";
    private final IProject sourceProj;
    private final ProjectSourceParser projectSourceParser;
    private final Set<Def_ModulePar> selection;
    private Map<IPath, StringBuilder> copyMap;
    private List<IFile> filesToCopy;

    DependencyCollector(Set<Def_ModulePar> selection, IProject sourceProj) {
        this.selection = selection;
        this.sourceProj = sourceProj;
        this.projectSourceParser = GlobalParser.getProjectSourceParser((IProject)sourceProj);
    }

    public Map<IPath, StringBuilder> getCopyMap() {
        return this.copyMap;
    }

    public List<IFile> getFilesToCopy() {
        return this.filesToCopy;
    }

    public WorkspaceJob readDependencies() {
        WorkspaceJob job = new WorkspaceJob("ExtractModulePar: reading dependencies from source project"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)DependencyCollector.this.sourceProj);
                HashSet<IResource> allFiles = new HashSet<IResource>();
                HashSet asnFiles = new HashSet();
                TreeSet<ILocateableNode> dependencies = new TreeSet<ILocateableNode>(new LocationComparator());
                for (Def_ModulePar def : DependencyCollector.this.selection) {
                    HashSet nonSortedTempSet = new HashSet();
                    DependencyCollector.this.collectDependencies((Definition)def, nonSortedTempSet, allFiles, asnFiles);
                    dependencies.addAll(nonSortedTempSet);
                    allFiles.add(def.getLocation().getFile());
                    if (!dependencies.contains(def)) {
                        dependencies.add((ILocateableNode)def);
                    }
                    for (IResource r : allFiles) {
                        if (!(r instanceof IFile)) continue;
                        IFile f = (IFile)r;
                        Module m = projectSourceParser.containedModule(f);
                        ImportFinderVisitor impVisitor = new ImportFinderVisitor();
                        m.accept((ASTVisitor)impVisitor);
                        List impDefs = impVisitor.getImportDefs();
                        List friendDefs = impVisitor.getFriendDefs();
                        DependencyCollector.filterImportDefinitions(allFiles, impDefs, projectSourceParser);
                        DependencyCollector.filterFriendDefinitions(allFiles, friendDefs, projectSourceParser);
                        dependencies.addAll(impDefs);
                        dependencies.addAll(friendDefs);
                    }
                }
                DependencyCollector.this.copyMap = new HashMap();
                try {
                    InputStream is = null;
                    InputStreamReader isr = null;
                    IResource lastFile = null;
                    ILocateableNode lastD = null;
                    int currOffset = 0;
                    for (ILocateableNode d : dependencies) {
                        int toSkip;
                        IResource currFile = d.getLocation().getFile();
                        if (!(currFile instanceof IFile)) {
                            ErrorReporter.logError((String)("ExtractModulePar/DependencyCollector: IResource `" + currFile.getName() + "' is not an IFile."));
                            continue;
                        }
                        if (currFile != lastFile) {
                            lastD = null;
                            if (lastFile != null) {
                                DependencyCollector.this.addToCopyMap(lastFile.getProjectRelativePath(), DependencyCollector.MODULE_TRAILER);
                            }
                            if (isr != null) {
                                isr.close();
                            }
                            if (is != null) {
                                is.close();
                            }
                            is = ((IFile)currFile).getContents();
                            isr = new InputStreamReader(is, ((IFile)currFile).getCharset());
                            currOffset = 0;
                            Module m = projectSourceParser.containedModule((IFile)currFile);
                            String moduleName = m.getIdentifier().getTtcnName();
                            DependencyCollector.this.addToCopyMap(currFile.getProjectRelativePath(), MessageFormat.format(DependencyCollector.MODULE_HEADER, moduleName));
                        }
                        if ((toSkip = DependencyCollector.this.getNodeOffset(d) - currOffset) < 0) {
                            DependencyCollector.this.reportOverlappingError(lastD, d);
                            continue;
                        }
                        isr.skip(toSkip);
                        if (d instanceof ImportModule && lastD instanceof ImportModule) {
                            DependencyCollector.this.addToCopyMap(currFile.getProjectRelativePath(), DependencyCollector.SINGLE_SEPARATOR);
                        } else if (d instanceof FriendModule && lastD instanceof FriendModule) {
                            DependencyCollector.this.addToCopyMap(currFile.getProjectRelativePath(), DependencyCollector.SINGLE_SEPARATOR);
                        } else {
                            DependencyCollector.this.addToCopyMap(currFile.getProjectRelativePath(), DependencyCollector.DOUBLE_SEPARATOR);
                        }
                        this.insertDependency(d, currFile, isr);
                        currOffset = d.getLocation().getEndOffset();
                        lastFile = currFile;
                        lastD = d;
                    }
                    if (lastFile != null) {
                        DependencyCollector.this.addToCopyMap(lastFile.getProjectRelativePath(), DependencyCollector.MODULE_TRAILER);
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    DependencyCollector.this.filesToCopy = new ArrayList();
                    for (IResource r : asnFiles) {
                        if (!(r instanceof IFile)) {
                            ErrorReporter.logError((String)("ExtractModulePar/DependencyCollector: IResource `" + r.getName() + "' is not an IFile."));
                            continue;
                        }
                        DependencyCollector.this.filesToCopy.add((IFile)r);
                    }
                }
                catch (IOException ioe) {
                    ErrorReporter.logError((String)"ExtractModulePar/DependencyCollector: Error while reading source project.");
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            private void insertDependency(ILocateableNode d, IResource res, InputStreamReader isr) throws IOException {
                char[] content = new char[d.getLocation().getEndOffset() - DependencyCollector.this.getNodeOffset(d)];
                isr.read(content, 0, content.length);
                DependencyCollector.this.addToCopyMap(res.getProjectRelativePath(), new String(content));
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    private void collectDependencies(Definition start, Set<ILocateableNode> allDefs, Set<IResource> imports, Set<IResource> asnFiles) {
        HashSet<Definition> prevDefs = new HashSet<Definition>();
        prevDefs.add(start);
        while (!allDefs.containsAll(prevDefs)) {
            HashSet<Definition> currDefs = new HashSet<Definition>();
            allDefs.addAll(prevDefs);
            for (Definition d : prevDefs) {
                DependencyFinderVisitor vis = new DependencyFinderVisitor(currDefs, imports, asnFiles);
                d.accept((ASTVisitor)vis);
            }
            prevDefs = currDefs;
        }
    }

    private static void filterImportDefinitions(Set<IResource> allFiles, List<ImportModule> importDefs, ProjectSourceParser projParser) {
        ArrayList<Identifier> allFileIds = new ArrayList<Identifier>(allFiles.size());
        for (IResource r : allFiles) {
            if (!(r instanceof IFile)) continue;
            IFile f = (IFile)r;
            Module m = projParser.containedModule(f);
            allFileIds.add(m.getIdentifier());
        }
        ListIterator<ImportModule> importIt = importDefs.listIterator();
        while (importIt.hasNext()) {
            ImportModule im = importIt.next();
            Identifier id = im.getIdentifier();
            if (allFileIds.contains(id)) continue;
            importIt.remove();
        }
    }

    private static void filterFriendDefinitions(Set<IResource> allFiles, List<FriendModule> friendDefs, ProjectSourceParser projParser) {
        ArrayList<Identifier> allFileIds = new ArrayList<Identifier>(allFiles.size());
        for (IResource r : allFiles) {
            if (!(r instanceof IFile)) continue;
            IFile f = (IFile)r;
            Module m = projParser.containedModule(f);
            allFileIds.add(m.getIdentifier());
        }
        ListIterator<FriendModule> importIt = friendDefs.listIterator();
        while (importIt.hasNext()) {
            FriendModule fm = importIt.next();
            Identifier id = fm.getIdentifier();
            if (allFileIds.contains(id)) continue;
            importIt.remove();
        }
    }

    private void addToCopyMap(IPath relativePath, String toAdd) {
        if (this.copyMap.containsKey(relativePath)) {
            StringBuilder sb = this.copyMap.get(relativePath);
            sb.append(toAdd);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(toAdd);
            this.copyMap.put(relativePath, sb);
        }
    }

    private int getNodeOffset(ILocateableNode node) {
        int o = node.getLocation().getOffset();
        return o;
    }

    private void reportOverlappingError(ILocateableNode defCurrent, ILocateableNode defOverlapping) {
        Location dLocOverlap = defOverlapping == null ? null : defOverlapping.getLocation();
        Location dLocCurr = defCurrent == null ? null : defCurrent.getLocation();
        String idOverlap = null;
        if (defOverlapping instanceof Definition) {
            idOverlap = ((Definition)defOverlapping).getIdentifier().toString();
        } else if (defOverlapping instanceof ImportModule) {
            idOverlap = "ImportModule{" + ((ImportModule)defOverlapping).getIdentifier().toString() + "}";
        } else if (defOverlapping instanceof FriendModule) {
            idOverlap = "FriendModule{" + ((FriendModule)defOverlapping).getIdentifier().toString() + "}";
        }
        String idCurr = null;
        if (defCurrent instanceof Definition) {
            idCurr = ((Definition)defCurrent).getIdentifier().toString();
        } else if (defCurrent instanceof ImportModule) {
            idCurr = "ImportModule{" + ((ImportModule)defCurrent).getIdentifier().toString() + "}";
        } else if (defCurrent instanceof FriendModule) {
            idCurr = "FriendModule{" + ((FriendModule)defCurrent).getIdentifier().toString() + "}";
        }
        String msg1 = dLocCurr == null ? "null" : "Definition id: " + idCurr + " (" + defCurrent.getClass().getSimpleName() + ") at " + dLocCurr.getFile() + ", offset " + dLocCurr.getOffset() + "-" + dLocCurr.getEndOffset();
        String msg2 = dLocOverlap == null ? "null" : "Definition id: " + idOverlap + " (" + defOverlapping.getClass().getSimpleName() + ") at " + dLocOverlap.getFile() + ", offset " + dLocOverlap.getOffset() + "-" + dLocOverlap.getEndOffset();
        ErrorReporter.logError((String)("Warning! Locations overlap while reading source project: \n" + msg1 + "\n WITH \n" + msg2));
    }

    static class ImportFinderVisitor
    extends ASTVisitor {
        private final List<ImportModule> importDefs = new ArrayList<ImportModule>();
        private final List<FriendModule> friendDefs = new ArrayList<FriendModule>();

        ImportFinderVisitor() {
        }

        private List<ImportModule> getImportDefs() {
            return this.importDefs;
        }

        private List<FriendModule> getFriendDefs() {
            return this.friendDefs;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof ImportModule) {
                this.importDefs.add((ImportModule)node);
                return 1;
            }
            if (node instanceof FriendModule) {
                this.friendDefs.add((FriendModule)node);
                return 1;
            }
            return 3;
        }
    }

    class DependencyFinderVisitor
    extends ASTVisitor {
        private final Set<Definition> definitions;
        private final Set<IResource> imports;
        private final Set<IResource> asnFiles;

        DependencyFinderVisitor(Set<Definition> definitions, Set<IResource> imports, Set<IResource> asnFiles) {
            this.definitions = definitions;
            this.imports = imports;
            this.asnFiles = asnFiles;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Undefined_LowerIdentifier_Value) {
                ((Undefined_LowerIdentifier_Value)node).getAsReference();
                return 3;
            }
            if (node instanceof Reference) {
                Definition def;
                Reference ref = (Reference)node;
                Assignment as = ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                if (as == null) {
                    return 3;
                }
                IResource asFile = as.getLocation().getFile();
                if ("asn".equals(asFile.getFileExtension())) {
                    this.imports.add(asFile);
                    this.asnFiles.add(asFile);
                    this.collectAllASNs(asFile);
                } else if (as instanceof Definition && !this.definitions.contains(def = (Definition)as) && this.isGoodType(def)) {
                    this.definitions.add(def);
                    IResource refLoc = ref.getLocation().getFile();
                    if (asFile != refLoc) {
                        this.imports.add(asFile);
                    }
                }
                return 3;
            }
            return 3;
        }

        private boolean isGoodType(Definition definition) {
            if (definition instanceof Def_Var || definition instanceof Def_Var_Template || definition instanceof FormalParameter || definition instanceof Def_Timer || definition instanceof Def_Port) {
                return false;
            }
            return !definition.isLocal();
        }

        private void collectAllASNs(IResource asnBaseFile) {
            if (asnBaseFile instanceof IFile) {
                IFile f = (IFile)asnBaseFile;
                Module mod = DependencyCollector.this.projectSourceParser.containedModule(f);
                List impMods = mod.getImportedModules();
                for (Module m : impMods) {
                    IResource impModRes = m.getLocation().getFile();
                    if (this.asnFiles.contains(impModRes)) continue;
                    this.asnFiles.add(impModRes);
                    this.collectAllASNs(impModRes);
                }
            }
        }
    }

    private class LocationComparator
    implements Comparator<ILocateableNode> {
        private LocationComparator() {
        }

        @Override
        public int compare(ILocateableNode arg0, ILocateableNode arg1) {
            int o1;
            IResource f1;
            IResource f0 = arg0.getLocation().getFile();
            if (!f0.equals((Object)(f1 = arg1.getLocation().getFile()))) {
                return f0.getFullPath().toString().compareTo(f1.getFullPath().toString());
            }
            int o0 = DependencyCollector.this.getNodeOffset(arg0);
            return o0 < (o1 = DependencyCollector.this.getNodeOffset(arg1)) ? -1 : (o0 == o1 ? 0 : 1);
        }
    }
}

