/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.parsers;

import java.util.regex.Pattern;
import org.eclipse.titan.log.viewer.parsers.MessageAnalyser;

public class MessageAnalyserFormat2
extends MessageAnalyser {
    private static final String LOCATION = ", location:";
    private static final String PROCESS_ID = ", process id:";
    private static final String TESTCASE_NAME = ", testcase name:";
    private static final String COMPONENT_TYPE = ", component type:";
    private static final String TTCN_3_PARALLEL_TEST_COMPONENT = "TTCN-3 Parallel Test Component started on";
    private static final String WITH_QUEUE_ID = "with queue id \\d+";
    private static final String RECEIVE_OPERATION_ON_PORT = "Receive operation on port";
    private static final String LOCAL_VERDICT_OF_PTC_COMPNAME = "Local verdict of PTC \\S++";
    private static final String PTC_WAS_CREATED_COMPONENT_REFERENCE_ONLY = "PTC was created. Component reference: [0-9]+\\, alive.*";
    private static final String COMPONENT_DONE_VERDICT = "Local verdict of PTC";

    @Override
    public String getType() {
        return "MessageAnalyserFormat2";
    }

    @Override
    protected boolean isComponentCreation() {
        String regexpComponent = "PTC was created. Component reference: [0-9]+\\,.*";
        if (Pattern.matches(regexpComponent, this.message)) {
            return true;
        }
        regexpComponent = PTC_WAS_CREATED_COMPONENT_REFERENCE_ONLY;
        if (Pattern.matches(regexpComponent, this.message)) {
            return true;
        }
        regexpComponent = "TTCN-3 Parallel Test Component started on .*";
        return Pattern.matches(regexpComponent, this.message);
    }

    @Override
    protected String getComponentTerminationReference() {
        String componentReference = "";
        String tmp = this.getTokenAfterString(COMPONENT_DONE_VERDICT, " ");
        componentReference = "with".equals(tmp) ? this.getTokenAfterString("component reference", " :") : this.getComponentRef(tmp);
        return componentReference;
    }

    @Override
    protected String getComponentTerminationVerdict() {
        String componentVerdict = "";
        String tmp = this.getTokenAfterString(COMPONENT_DONE_VERDICT, " ");
        componentVerdict = "with".equals(tmp) ? this.getTokenAfterString("component reference \\d++:") : this.getTokenAfterString(LOCAL_VERDICT_OF_PTC_COMPNAME);
        return componentVerdict;
    }

    @Override
    protected boolean isComponentTermination() {
        return this.message.contains(COMPONENT_DONE_VERDICT);
    }

    @Override
    public boolean isReceiveOperation() {
        return this.message.contains(RECEIVE_OPERATION_ON_PORT);
    }

    @Override
    public String getReceiveOperationTarget() {
        return this.getTokenAfterString(RECEIVE_OPERATION_ON_PORT);
    }

    @Override
    public String getReceiveOperationType() {
        String[] strings = this.message.split(WITH_QUEUE_ID);
        if (strings.length > 1) {
            return this.getTokenAfterString("with queue id \\d+:", " ");
        }
        strings = this.message.split(":");
        if (strings.length > 2) {
            return strings[1];
        }
        return "";
    }

    @Override
    protected String getComponentCreationReference() {
        if (this.message.startsWith(TTCN_3_PARALLEL_TEST_COMPONENT)) {
            return this.getComponentRef(this.getReference("Component reference:", COMPONENT_TYPE));
        }
        return this.getComponentRef(this.getTokenAfterString("Component reference:"));
    }

    @Override
    protected String getComponentDoneReference() {
        String compRef = this.getReference("PTC with component reference", "is done.");
        return this.getComponentRef(compRef);
    }

    @Override
    public String getPortConnectionSource() {
        return this.getReference("Connecting ports", " and ");
    }

    @Override
    public String getPortConnectionSourceRef() {
        return this.getComponentRef(this.getPortConnectionSource());
    }

    @Override
    public String getPortDisconnectionSource() {
        return this.getReference("Disconnecting ports", " and ");
    }

    @Override
    public String getPortDisconnectionSourceRef() {
        return this.getComponentRef(this.getPortDisconnectionSource());
    }

    @Override
    public String getPortConnectionTarget() {
        int startIndex = this.message.indexOf(" and ") + " and ".length();
        if (startIndex < 0 || startIndex >= this.message.length()) {
            return "";
        }
        return this.message.substring(startIndex, this.message.length() - 1).trim();
    }

    @Override
    public String getPortConnectionTargetRef() {
        return this.getComponentRef(this.getPortConnectionTarget());
    }

    @Override
    public String getStartFunctionReference() {
        int i = this.message.indexOf("on component");
        String compNameAndRef = this.message.substring(i + "on component".length() + 1, this.message.length() - 1);
        return this.getComponentRef(compNameAndRef);
    }

    @Override
    public String getPortUnMapping() {
        return this.getReference("Unmapping port", " from ");
    }

    @Override
    public String getPortMappingTarget() {
        int startIndex = this.message.indexOf(" to ") + " to ".length();
        if (startIndex < 0 || startIndex >= this.message.length()) {
            return "";
        }
        return this.message.substring(startIndex, this.message.length() - 1).trim();
    }

    @Override
    public String getPortUnMappingTarget() {
        int startIndex = this.message.indexOf(" from ") + " from ".length();
        if (startIndex < 0 || startIndex >= this.message.length()) {
            return "";
        }
        return this.message.substring(startIndex, this.message.length() - 1).trim();
    }

    @Override
    public String getPortMappingSource() {
        String compRef = this.getReference("Mapping port", " to ");
        return compRef;
    }

    @Override
    public boolean isPortDisconnection() {
        return this.message.contains("Disconnecting ports");
    }

    private String getReference(String startMessage, String stopMessage) {
        int startIndex = this.message.indexOf(startMessage);
        int stopIndex = this.message.indexOf(stopMessage);
        if (startIndex < 0 || stopIndex < 0) {
            return "";
        }
        if (startIndex >= stopIndex) {
            return "";
        }
        return this.message.substring(startIndex + startMessage.length() + 1, stopIndex).trim();
    }

    @Override
    protected String getComponentCreationName() {
        if (this.message.contains("component name:")) {
            String compRef = null;
            if (this.message.contains(TESTCASE_NAME)) {
                compRef = this.getReference("component name:", TESTCASE_NAME);
            } else if (this.message.contains(PROCESS_ID)) {
                compRef = this.getReference("component name:", PROCESS_ID);
            } else if (this.message.contains(LOCATION)) {
                compRef = this.getReference("component name:", LOCATION);
            } else {
                return this.getTokenAfterString("component name:");
            }
            return compRef;
        }
        return "";
    }
}

