/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.wizards.projectFormat.NewTITANProjectImportMainPage;
import org.eclipse.titan.designer.wizards.projectFormat.NewTITANProjectImportOptionsPage;
import org.eclipse.titan.designer.wizards.projectFormat.TpdImporter;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewTITANProjectImportWizard
extends BasicNewResourceWizard
implements IImportWizard {
    private static final String NEWPROJECT_WINDOWTITLE = "Import new TITAN Project from .tpd file";
    private static final String NEWPROJECT_TITLE = "Create a TITAN Project";
    private static final String NEWPROJECT_DESCRIPTION = "Create a new TITAN project in the workspace or in an external location";
    private NewTITANProjectImportMainPage mainPage;
    private NewTITANProjectImportOptionsPage optionsPage;
    private final TpdImporter tpdImporter = new TpdImporter(Display.getDefault().getActiveShell(), false);

    public void addPages() {
        super.addPages();
        this.mainPage = new NewTITANProjectImportMainPage(NEWPROJECT_WINDOWTITLE);
        this.mainPage.setTitle(NEWPROJECT_TITLE);
        this.mainPage.setDescription(NEWPROJECT_DESCRIPTION);
        this.addPage((IWizardPage)this.mainPage);
        this.optionsPage = new NewTITANProjectImportOptionsPage();
        this.addPage((IWizardPage)this.optionsPage);
    }

    public boolean performFinish() {
        final ArrayList projectsCreated = new ArrayList();
        try {
            new ProgressMonitorDialog(null).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    boolean result = true;
                    monitor.beginTask("Importing the data of the project", 1);
                    try {
                        result = NewTITANProjectImportWizard.this.tpdImporter.internalFinish(NewTITANProjectImportWizard.this.mainPage.getProjectFile(), NewTITANProjectImportWizard.this.optionsPage.isSkipExistingProjects(), NewTITANProjectImportWizard.this.optionsPage.isOpenPropertiesForAllImports(), NewTITANProjectImportWizard.this.optionsPage.islimitImportProcesses(), projectsCreated, monitor, NewTITANProjectImportWizard.this.mainPage.getSearchPaths());
                    }
                    catch (Exception e) {
                        ErrorReporter.logExceptionStackTrace((Exception)e);
                        result = false;
                    }
                    if (!result) {
                        for (IProject project : projectsCreated) {
                            try {
                                project.delete(true, null);
                            }
                            catch (CoreException e) {
                                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                            }
                        }
                        ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Import failed", (String)"There were some errors during import.\nPlease check the error log for more information.");
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(NEWPROJECT_WINDOWTITLE);
        super.init(workbench, selection);
    }
}

