/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.modulepar;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.titan.common.parsers.cfg.indices.ModuleParameterSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.pages.modulepar.ModuleParameterSectionPage;
import org.eclipse.titan.designer.editors.configeditor.pages.modulepar.ModuleParameterTransfer;

public final class ModuleParameterSectionDragSourceListener
implements DragSourceListener {
    private final TableViewer viewer;
    private final ModuleParameterSectionPage moduleParSubPage;

    public ModuleParameterSectionDragSourceListener(ModuleParameterSectionPage moduleParSubPage, TableViewer viewer) {
        this.moduleParSubPage = moduleParSubPage;
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            this.viewer.getTable().setRedraw(false);
            if (event.detail == 2) {
                this.moduleParSubPage.removeSelectedParameters();
            }
            this.viewer.getTable().setRedraw(true);
            this.viewer.refresh();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (ModuleParameterTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            ArrayList<ModuleParameterSectionHandler.ModuleParameter> items = new ArrayList<ModuleParameterSectionHandler.ModuleParameter>();
            if (!selection.isEmpty()) {
                for (Object element : selection) {
                    if (!(element instanceof ModuleParameterSectionHandler.ModuleParameter)) continue;
                    items.add((ModuleParameterSectionHandler.ModuleParameter)element);
                }
                event.data = items.toArray(new ModuleParameterSectionHandler.ModuleParameter[items.size()]);
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = !selection.isEmpty() && selection.getFirstElement() instanceof ModuleParameterSectionHandler.ModuleParameter;
    }
}

