/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.nebula.gallery.finder.widgets;

import java.util.ArrayList;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.nebula.gallery.finder.SWTGalleryBot;
import org.eclipse.swtbot.nebula.gallery.finder.widgets.SWTBotGalleryItem;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.SWTBotWidget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.results.ArrayResult;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.eclipse.swtbot.swt.finder.utils.StringUtils;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.hamcrest.SelfDescribing;

@SWTBotWidget(clasz=Gallery.class, preferredName="gallery")
public class SWTBotGallery
extends AbstractSWTBotControl<Gallery> {
    public SWTBotGallery(Gallery w) throws WidgetNotFoundException {
        super((Control)w);
    }

    public SWTBotGallery(Gallery widget, SelfDescribing description) {
        super((Control)widget, description);
    }

    public int getItemCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((Gallery)SWTBotGallery.this.widget).getItemCount();
            }
        });
    }

    public int getSelectionCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((Gallery)SWTBotGallery.this.widget).getSelectionCount();
            }
        });
    }

    public SWTBotGalleryItem[] selection() {
        return (SWTBotGalleryItem[])this.syncExec((Result)new Result<SWTBotGalleryItem[]>(){

            public SWTBotGalleryItem[] run() {
                GalleryItem[] selection = ((Gallery)SWTBotGallery.this.widget).getSelection();
                SWTBotGalleryItem[] res = new SWTBotGalleryItem[selection.length];
                int i = 0;
                while (i < selection.length) {
                    GalleryItem galleryItemSelected = selection[i];
                    res[i] = new SWTBotGalleryItem(galleryItemSelected);
                    ++i;
                }
                return res;
            }
        });
    }

    public void select(int ... indices) {
        this.waitForEnabled();
        if (indices.length > 1) {
            this.assertMultiSelect();
        }
        this.setFocus();
        this.log.debug("Selecting items {} in gallery {1}", (Object)StringUtils.join((int[])indices, (String)", "), (Object)this);
        this.unselect();
        int i = 0;
        while (i < indices.length) {
            this.additionalSelectAndNotify(indices[i]);
            ++i;
        }
    }

    public SWTBotGallery select(final String ... items) {
        this.waitForEnabled();
        this.setFocus();
        this.asyncExec(new VoidResult(){

            public void run() {
                ArrayList<GalleryItem> selection = new ArrayList<GalleryItem>();
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    SWTBotGalleryItem si = SWTBotGallery.this.getGalleryItem(item);
                    selection.add((GalleryItem)si.widget);
                    ++n2;
                }
                if (!SWTBotGallery.this.hasStyle(SWTBotGallery.this.widget, 2) && items.length > 1) {
                    SWTBotGallery.this.log.warn("Gallery does not support SWT.MULTI, cannot make multiple selections");
                }
                ((Gallery)SWTBotGallery.this.widget).setSelection(selection.toArray(new GalleryItem[selection.size()]));
            }
        });
        this.notifySelect();
        return this;
    }

    public SWTBotGallery select(final SWTBotGalleryItem ... items) {
        this.assertEnabled();
        this.setFocus();
        this.asyncExec(new VoidResult(){

            public void run() {
                ArrayList<GalleryItem> selection = new ArrayList<GalleryItem>();
                SWTBotGalleryItem[] sWTBotGalleryItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    SWTBotGalleryItem galleryItem = sWTBotGalleryItemArray[n2];
                    selection.add((GalleryItem)galleryItem.widget);
                    ++n2;
                }
                if (!SWTBotGallery.this.hasStyle(SWTBotGallery.this.widget, 2) && items.length > 1) {
                    SWTBotGallery.this.log.warn("Gallery does not support SWT.MULTI, cannot make multiple selections");
                }
                ((Gallery)SWTBotGallery.this.widget).setSelection(selection.toArray(new GalleryItem[0]));
            }
        });
        this.notifySelect();
        return this;
    }

    private void assertMultiSelect() {
        Assert.isLegal((boolean)this.hasStyle(this.widget, 2), (Object)"Gallery does not support multi selection.");
    }

    public SWTBotGalleryItem getGalleryItem(final int index) {
        try {
            new SWTGalleryBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find gallery item for index " + index;
                }

                public boolean test() throws Exception {
                    return SWTBotGallery.this.getItem(index) != null;
                }
            });
        }
        catch (TimeoutException e) {
            throw new WidgetNotFoundException("Timed out waiting for gallery item in index " + index, (Throwable)e);
        }
        return new SWTBotGalleryItem(this.getItem(index));
    }

    protected GalleryItem getItem(final int index) {
        return (GalleryItem)this.syncExec((Result)new WidgetResult<GalleryItem>(){

            public GalleryItem run() {
                return ((Gallery)SWTBotGallery.this.widget).getItem(index);
            }
        });
    }

    public SWTBotGalleryItem getGalleryItem(final String nodeText) throws WidgetNotFoundException {
        try {
            new SWTBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find node with text " + nodeText;
                }

                public boolean test() throws Exception {
                    return SWTBotGallery.this.getItem(nodeText) != null;
                }
            });
        }
        catch (TimeoutException e) {
            throw new WidgetNotFoundException("Timed out waiting for gallery item " + nodeText, (Throwable)e);
        }
        return new SWTBotGalleryItem(this.getItem(nodeText));
    }

    private GalleryItem getItem(final String nodeText) {
        return (GalleryItem)this.syncExec((Result)new WidgetResult<GalleryItem>(){

            public GalleryItem run() {
                GalleryItem[] items;
                GalleryItem[] galleryItemArray = items = ((Gallery)SWTBotGallery.this.widget).getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    GalleryItem item = galleryItemArray[n2];
                    if (item.getText().equals(nodeText)) {
                        return item;
                    }
                    ++n2;
                }
                return null;
            }
        });
    }

    public SWTBotGalleryItem[] getAllItems() {
        return (SWTBotGalleryItem[])this.syncExec((ArrayResult)new ArrayResult<SWTBotGalleryItem>(){

            public SWTBotGalleryItem[] run() {
                GalleryItem[] items = ((Gallery)SWTBotGallery.this.widget).getItems();
                SWTBotGalleryItem[] result = new SWTBotGalleryItem[items.length];
                int i = 0;
                while (i < items.length) {
                    try {
                        result[i] = new SWTBotGalleryItem(items[i]);
                    }
                    catch (WidgetNotFoundException e) {
                        return new SWTBotGalleryItem[0];
                    }
                    ++i;
                }
                return result;
            }
        });
    }

    protected void notifySelect() {
        this.notify(6);
        this.notify(5);
        this.notify(26);
        this.notify(15);
        this.notify(3);
        this.notify(13);
        this.notify(4);
        this.notify(32);
        this.notify(5);
        this.notify(7);
        this.notify(27);
        this.notify(16);
    }

    public void unselect() {
        this.waitForEnabled();
        this.setFocus();
        this.asyncExec(new VoidResult(){

            public void run() {
                SWTBotGallery.this.log.debug("Unselecting all in {}", (Object)SWTBotGallery.this.widget);
                ((Gallery)SWTBotGallery.this.widget).deselectAll();
            }
        });
        this.notifySelect();
    }

    private void additionalSelectAndNotify(final int j) {
        this.asyncExec(new VoidResult(){

            public void run() {
                GalleryItem[] oldSelection;
                ArrayList<GalleryItem> newSelection = new ArrayList<GalleryItem>();
                GalleryItem[] galleryItemArray = oldSelection = ((Gallery)SWTBotGallery.this.widget).getSelection();
                int n = oldSelection.length;
                int n2 = 0;
                while (n2 < n) {
                    GalleryItem galleryItem = galleryItemArray[n2];
                    newSelection.add(galleryItem);
                    ++n2;
                }
                newSelection.add(((Gallery)SWTBotGallery.this.widget).getItem(j));
                ((Gallery)SWTBotGallery.this.widget).setSelection(newSelection.toArray(new GalleryItem[newSelection.size()]));
            }
        });
        this.notifySelect();
    }
}

