/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.event;

import org.eclipse.linuxtools.tmf.event.TmfTimestamp;

public class TmfTimeRange {
    public static final TmfTimeRange Eternity = new TmfTimeRange(TmfTimestamp.BigBang, TmfTimestamp.BigCrunch);
    private final TmfTimestamp fStartTime;
    private final TmfTimestamp fEndTime;

    private TmfTimeRange() {
        throw new AssertionError();
    }

    public TmfTimeRange(TmfTimestamp startTime, TmfTimestamp endTime) {
        if (startTime == null || endTime == null) {
            throw new IllegalArgumentException();
        }
        this.fStartTime = new TmfTimestamp(startTime);
        this.fEndTime = new TmfTimestamp(endTime);
    }

    public TmfTimeRange(TmfTimeRange other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fStartTime = new TmfTimestamp(other.fStartTime);
        this.fEndTime = new TmfTimestamp(other.fEndTime);
    }

    public TmfTimestamp getStartTime() {
        return new TmfTimestamp(this.fStartTime);
    }

    public TmfTimestamp getEndTime() {
        return new TmfTimestamp(this.fEndTime);
    }

    public boolean contains(TmfTimestamp ts) {
        if (ts.equals(TmfTimestamp.Zero)) {
            return true;
        }
        return this.fStartTime.compareTo(ts, true) <= 0 && this.fEndTime.compareTo(ts, true) >= 0;
    }

    public TmfTimeRange getIntersection(TmfTimeRange other) {
        if (this.fStartTime.compareTo(other.fEndTime, true) > 0 || this.fEndTime.compareTo(other.fStartTime, true) < 0) {
            return null;
        }
        return new TmfTimeRange(this.fStartTime.compareTo(other.fStartTime, true) < 0 ? other.fStartTime : this.fStartTime, this.fEndTime.compareTo(other.fEndTime, true) > 0 ? other.fEndTime : this.fEndTime);
    }

    public boolean contains(TmfTimeRange range) {
        TmfTimestamp startTime = range.getStartTime();
        TmfTimestamp endTime = range.getEndTime();
        return this.fStartTime.compareTo(startTime, true) <= 0 && this.fEndTime.compareTo(endTime, true) >= 0;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.fStartTime.hashCode();
        result = 37 * result + this.fEndTime.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TmfTimeRange)) {
            return false;
        }
        TmfTimeRange range = (TmfTimeRange)other;
        return range.fStartTime.equals(this.fStartTime) && range.fEndTime.equals(this.fEndTime);
    }

    public String toString() {
        return "[TmfTimeRange(" + this.fStartTime + ":" + this.fEndTime + ")]";
    }
}

