/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.ui.views.project.ProjectView;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectNode;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeleteProjectHandler
extends AbstractHandler {
    private TmfProjectNode fProject = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        if (!(page.getActivePart() instanceof ProjectView)) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.tmf.ui.views.project");
        if (selection instanceof StructuredSelection) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            TmfProjectNode tmfProjectNode = this.fProject = element instanceof TmfProjectNode ? (TmfProjectNode)element : null;
        }
        return this.fProject != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = this.fProject.getProject();
        ITmfProjectTreeNode parent = this.fProject.getParent();
        try {
            parent.removeChild(this.fProject);
            parent.refresh();
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

