/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import org.eclipse.linuxtools.oprofile.core.model.OpModelSample;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.swt.graphics.Image;

public class UiModelSample
implements IUiModelElement {
    private IUiModelElement _parent;
    private OpModelSample _sample;
    private int _totalCount;

    public UiModelSample(IUiModelElement parent, OpModelSample sample, int totalCount) {
        this._parent = parent;
        this._sample = sample;
        this._totalCount = totalCount;
    }

    public String toString() {
        double countPercentage = (double)this._sample.getCount() / (double)this._totalCount;
        String percentage = OprofileUiPlugin.getPercentageString(countPercentage);
        return String.valueOf(percentage) + " " + OprofileUiMessages.getString("uimodel.sample.on.line") + Integer.toString(this._sample.getLine());
    }

    public int getLine() {
        return this._sample.getLine();
    }

    public double getCountPercentage() {
        return (double)this._sample.getCount() / (double)this._totalCount;
    }

    public String getLabelText() {
        return this.toString();
    }

    public IUiModelElement[] getChildren() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public IUiModelElement getParent() {
        return this._parent;
    }

    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/sample.gif").createImage();
    }
}

