/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.event;

import org.eclipse.linuxtools.lttng.event.LttngEventContent;
import org.eclipse.linuxtools.lttng.event.LttngEventReference;
import org.eclipse.linuxtools.lttng.event.LttngEventType;
import org.eclipse.linuxtools.lttng.event.LttngTimestamp;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfEventReference;
import org.eclipse.linuxtools.tmf.event.TmfEventSource;
import org.eclipse.linuxtools.tmf.event.TmfEventType;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.trace.TmfTrace;

public class LttngEvent
extends TmfEvent {
    private JniEvent jniEventReference = null;
    private TmfTrace<LttngEvent> parentTrace = null;

    public LttngEvent(TmfTrace<LttngEvent> parent, LttngTimestamp timestamp, TmfEventSource source, LttngEventType type, LttngEventContent content, LttngEventReference reference, JniEvent lttEvent) {
        super((TmfTimestamp)timestamp, source, (TmfEventType)type, (TmfEventReference)reference);
        this.fContent = content;
        this.jniEventReference = lttEvent;
        this.setParentTrace(parent);
    }

    public LttngEvent(LttngEvent oldEvent) {
        this(oldEvent.getParentTrace(), (LttngTimestamp)oldEvent.getTimestamp(), oldEvent.getSource(), oldEvent.getType(), oldEvent.getContent(), (LttngEventReference)oldEvent.getReference(), oldEvent.jniEventReference);
    }

    public TmfTrace<LttngEvent> getParentTrace() {
        return this.parentTrace;
    }

    public void setParentTrace(TmfTrace<LttngEvent> parentTrace) {
        this.parentTrace = parentTrace;
    }

    public String getChannelName() {
        return this.getType().getTracefileName();
    }

    public long getCpuId() {
        return this.getType().getCpuId();
    }

    public String getMarkerName() {
        return this.getType().getMarkerName();
    }

    public int getMarkerId() {
        return this.getType().getMarkerId();
    }

    public LttngEventContent getContent() {
        return (LttngEventContent)this.fContent;
    }

    public void setContent(LttngEventContent newContent) {
        this.fContent = newContent;
    }

    public LttngEventType getType() {
        return (LttngEventType)this.fType;
    }

    public void setType(LttngEventType newType) {
        this.fType = newType;
    }

    public synchronized void updateJniEventReference(JniEvent newJniEventReference) {
        this.jniEventReference = newJniEventReference;
    }

    public synchronized JniEvent convertEventTmfToJni() {
        JniEvent tmpEvent = null;
        if (this.jniEventReference.getParentTracefile().getParentTrace().getCurrentEventTimestamp().getTime() == this.getTimestamp().getValue()) {
            tmpEvent = this.jniEventReference;
        } else {
            System.out.println("convertEventTmfToJni() failed: Unsynced Timestamp > TMF:" + this.getTimestamp().getValue() + " <--> JNI:" + this.jniEventReference.getParentTracefile().getParentTrace().getCurrentEventTimestamp().getTime());
        }
        return tmpEvent;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[LttngEvent(");
        result.append("Timestamp:" + this.getTimestamp().getValue());
        result.append(",Channel:" + this.getChannelName());
        result.append(",CPU:" + this.getCpuId());
        result.append(",Marker:" + this.getMarkerName());
        result.append(",Content:" + (Object)((Object)this.getContent()) + ")]");
        return result.toString();
    }

    public LttngEvent clone() {
        LttngEvent clone = (LttngEvent)super.clone();
        clone.getContent().setEvent(clone);
        clone.parentTrace = this.parentTrace;
        clone.jniEventReference = this.jniEventReference;
        return clone;
    }
}

