/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.migrator.ConnectorMigrator;
import org.eclipse.mylyn.internal.tasks.ui.migrator.Messages;
import org.eclipse.mylyn.internal.tasks.ui.migrator.TaskPredicates;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CompleteConnectorMigrationWizard
extends Wizard {
    private final ConnectorMigrator migrator;

    public CompleteConnectorMigrationWizard(ConnectorMigrator migrator) {
        this.migrator = migrator;
    }

    public void addPages() {
        this.setWindowTitle(Messages.CompleteConnectorMigrationWizard_Complete_Connector_Migration);
        if (!this.migrator.allQueriesMigrated()) {
            this.addPage((IWizardPage)new WizardPage(Messages.CompleteConnectorMigrationWizard_Migrate_Queries){

                public void createControl(Composite parent) {
                    this.setTitle(Messages.CompleteConnectorMigrationWizard_Have_You_Recreated_Your_Queries);
                    String message = Messages.CompleteConnectorMigrationWizard_ensure_created_queries;
                    if (CompleteConnectorMigrationWizard.this.migrator.anyQueriesMigrated()) {
                        message = Messages.CompleteConnectorMigrationWizard_Queries_not_migrated;
                    }
                    this.setMessage(NLS.bind((String)Messages.CompleteConnectorMigrationWizard_first_page_message, (Object)message), 1);
                    Composite c = new Composite(parent, 0);
                    GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(c);
                    Label oldQueriesLabel = new Label(c, 0);
                    oldQueriesLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
                    oldQueriesLabel.setText(Messages.CompleteConnectorMigrationWizard_Queries_Using_Old_Connectors);
                    Label newQueriesLabel = new Label(c, 0);
                    newQueriesLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
                    newQueriesLabel.setText(Messages.CompleteConnectorMigrationWizard_Queries_Using_New_Connectors);
                    CompleteConnectorMigrationWizard.this.createQueryTree(c, CompleteConnectorMigrationWizard.this.createRepositoryQueryMap(CompleteConnectorMigrationWizard.this.migrator.getSelectedConnectors().keySet()));
                    CompleteConnectorMigrationWizard.this.createQueryTree(c, CompleteConnectorMigrationWizard.this.createRepositoryQueryMap(CompleteConnectorMigrationWizard.this.migrator.getSelectedConnectors().values()));
                    this.setControl((Control)c);
                }
            });
        }
        this.addPage((IWizardPage)new WizardPage(Messages.CompleteConnectorMigrationWizard_Complete_Migration){

            public void createControl(Composite parent) {
                this.setTitle(Messages.CompleteConnectorMigrationWizard_Complete_Migration);
                this.setMessage(Messages.CompleteConnectorMigrationWizard_second_page_message, 1);
                Composite c = new Composite(parent, 0);
                GridLayoutFactory.fillDefaults().applyTo(c);
                Text text = new Text(c, 74);
                text.setText(Messages.CompleteConnectorMigrationWizard_second_page_text);
                GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(600, -1).applyTo((Control)text);
                this.setControl((Control)c);
            }

            public boolean isPageComplete() {
                return super.isPageComplete() && this.isCurrentPage();
            }
        });
    }

    protected TreeViewer createQueryTree(Composite parent, Map<TaskRepository, ? extends Set<RepositoryQuery>> queries) {
        TreeViewer viewer = new TreeViewer(parent);
        GridDataFactory.fillDefaults().grab(false, true).hint(500, -1).applyTo(viewer.getControl());
        viewer.setContentProvider((IContentProvider)new MapContentProvider(queries));
        viewer.setInput(queries);
        viewer.setComparator(new ViewerComparator());
        viewer.setLabelProvider((IBaseLabelProvider)new TaskElementLabelProvider(){
            private final TaskRepositoryLabelProvider repositoryLabelProvider = new TaskRepositoryLabelProvider();

            @Override
            public Image getImage(Object element) {
                if (element instanceof TaskRepository) {
                    return this.repositoryLabelProvider.getImage(element);
                }
                return super.getImage(element);
            }

            @Override
            public String getText(Object object) {
                if (object instanceof TaskRepository) {
                    return this.repositoryLabelProvider.getText(object);
                }
                return super.getText(object);
            }
        });
        viewer.addDoubleClickListener(event -> {
            Object element;
            if (viewer.getSelection() instanceof IStructuredSelection && (element = ((IStructuredSelection)viewer.getSelection()).getFirstElement()) instanceof IRepositoryQuery) {
                IRepositoryQuery query = (IRepositoryQuery)element;
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(query.getConnectorKind());
                TasksUiInternal.openEditQueryDialog(connectorUi, query);
            }
        });
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> viewer.expandAll());
        return viewer;
    }

    public boolean performFinish() {
        Job job = new Job(Messages.CompleteConnectorMigrationWizard_Migrating_Tasks_and_Private_Data){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.CompleteConnectorMigrationWizard_Completing_connector_migration, -1);
                Collection<String> newConnectors = CompleteConnectorMigrationWizard.this.migrator.getSelectedConnectors().values();
                CompleteConnectorMigrationWizard.this.waitForQueriesToSynchronize(newConnectors, monitor);
                CompleteConnectorMigrationWizard.this.migrator.migrateTasks(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setSystem(false);
        job.schedule();
        return true;
    }

    protected void waitForQueriesToSynchronize(Collection<String> newConnectors, IProgressMonitor monitor) {
        monitor.subTask(Messages.CompleteConnectorMigrationWizard_Waiting_for_queries_to_synchronize);
        long start = System.currentTimeMillis();
        Set queries = this.createRepositoryQueryMap(newConnectors).values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        while (queries.stream().anyMatch(TaskPredicates.isSynchronizing()) && System.currentTimeMillis() - start < TimeUnit.MILLISECONDS.convert(20L, TimeUnit.MINUTES)) {
            try {
                Thread.sleep(TimeUnit.MILLISECONDS.convert(3L, TimeUnit.SECONDS));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected Map<TaskRepository, Set<RepositoryQuery>> createRepositoryQueryMap(Collection<String> kinds) {
        HashMap repositories = new HashMap();
        for (String kind : kinds) {
            for (TaskRepository repository : this.migrator.getRepositoryManager().getRepositories(kind)) {
                Set queriesForUrl = TasksUiPlugin.getTaskList().getRepositoryQueries(repository.getRepositoryUrl());
                Set queries = queriesForUrl.stream().filter(TaskPredicates.isQueryForConnector(kind)).collect(Collectors.toUnmodifiableSet());
                if (queries.isEmpty()) continue;
                repositories.put(repository, queries);
            }
        }
        return Collections.unmodifiableMap(repositories);
    }

    final class MapContentProvider
    implements ITreeContentProvider {
        private final Map<?, ? extends Collection<?>> map;

        private MapContentProvider(Map<?, ? extends Collection<?>> map) {
            this.map = map;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return this.map.containsKey(element);
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).keySet().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (this.map.get(parentElement) == null) {
                return null;
            }
            return this.map.get(parentElement).toArray();
        }
    }
}

