/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.wizard;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.security.ui.SecurityUIMsg;
import org.eclipse.equinox.internal.security.ui.wizard.CertificateImportWizard;
import org.eclipse.equinox.internal.security.ui.wizard.CertificateViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CertificateImportCertSelectPage
extends WizardPage
implements Listener {
    private Composite certPreview;
    private Combo certDropDown;
    private List<Certificate> certList;
    static CertificateFactory certFact;

    static {
        try {
            certFact = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    protected CertificateImportCertSelectPage(String pageName) {
        super(pageName);
        this.setTitle(SecurityUIMsg.WIZARD_SELECT_CERT);
        this.setDescription(SecurityUIMsg.WIZARD_SELECT_CERT_FROM_DROP_DOWN);
    }

    public void createControl(Composite parent) {
        Composite certSelectComposite = new Composite(parent, 0);
        this.setControl((Control)certSelectComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        certSelectComposite.setLayout((Layout)layout);
        certSelectComposite.setLayoutData((Object)new GridData(768));
        this.certDropDown = new Combo(certSelectComposite, 12);
        this.certDropDown.setLayoutData((Object)new GridData(768));
        this.populateDropDown();
        this.certPreview = new Composite(certSelectComposite, 0);
        this.certPreview.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        this.certPreview.setLayoutData((Object)gd);
    }

    private void populateDropDown() {
        CertificateImportWizard certImportWizard = (CertificateImportWizard)this.getWizard();
        if (certImportWizard.selectedImportFile == null) {
            return;
        }
        if (this.certDropDown.getItemCount() > 0) {
            this.certDropDown.removeAll();
        }
        try {
            this.certList = new ArrayList<Certificate>();
            for (Certificate certificate : certFact.generateCertificates(new FileInputStream(certImportWizard.selectedImportFile))) {
                this.certList.add(certificate);
            }
        }
        catch (FileNotFoundException | CertificateException exception) {
            this.setErrorMessage(exception.getMessage());
        }
        for (Certificate certificate : this.certList) {
            X509Certificate x509Cert = (X509Certificate)certificate;
            String subjectDN = x509Cert.getSubjectX500Principal().getName();
            this.certDropDown.add(subjectDN);
        }
        this.certDropDown.addListener(13, (Listener)this);
    }

    public void handleEvent(Event e) {
        if (e.widget == this.certDropDown) {
            X509Certificate x509Cert = (X509Certificate)this.certList.get(this.certDropDown.getSelectionIndex());
            this.showCertificate(x509Cert);
            ((CertificateImportWizard)this.getWizard()).selectCert = x509Cert;
            this.getWizard().getContainer().updateButtons();
        }
    }

    public void showCertificate(X509Certificate cert) {
        Control[] ctrls;
        Control[] controlArray = ctrls = this.certPreview.getChildren();
        int n = ctrls.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            ctrl.dispose();
            ++n2;
        }
        CertificateViewer certViewer = new CertificateViewer(this.certPreview);
        certViewer.setCertificate(cert);
        this.certPreview.layout();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.populateDropDown();
        }
        super.setVisible(visible);
    }

    public boolean canFlipToNextPage() {
        return ((CertificateImportWizard)this.getWizard()).selectCert != null;
    }
}

