/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateListSelectionPage;
import org.eclipse.cdt.ui.templateengine.pages.UIWizardPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

class WizardNode
implements IWizardNode {
    private IWizard wizard;
    private Template template;
    private TemplateListSelectionPage parentPage;

    public WizardNode(TemplateListSelectionPage parentPage, Template template) {
        this.parentPage = parentPage;
        this.template = template;
    }

    public void dispose() {
        if (this.wizard != null) {
            this.wizard.dispose();
            this.wizard = null;
        }
    }

    public Template getTemplate() {
        return this.template;
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public IWizard getWizard() {
        if (this.wizard != null) {
            return this.wizard;
        }
        this.wizard = new Wizard(){
            private boolean finishPressed;
            {
                this.setWindowTitle(WizardNode.this.template.getLabel());
            }

            public void addPages() {
                IWizardDataPage[] wpages = null;
                try {
                    IWizardDataPage[] iWizardDataPageArray = wpages = WizardNode.this.parentPage.getPagesAfterTemplateSelection();
                    int n = wpages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWizardDataPage wpage = iWizardDataPageArray[n2];
                        this.addPage(wpage);
                        ++n2;
                    }
                }
                catch (Exception wpage) {
                    // empty catch block
                }
                Map<String, UIWizardPage> pages = WizardNode.this.template.getUIPages();
                Iterator<String> iterator = WizardNode.this.template.getPagesOrderVector().iterator();
                while (iterator.hasNext()) {
                    String element;
                    String id = element = iterator.next();
                    this.addPage(pages.get(id));
                }
                IWizardDataPage[] iWizardDataPageArray = wpages = WizardNode.this.parentPage.getPagesAfterTemplatePages();
                int n = wpages.length;
                int n3 = 0;
                while (n3 < n) {
                    IWizardDataPage wpage = iWizardDataPageArray[n3];
                    this.addPage(wpage);
                    ++n3;
                }
            }

            public boolean performFinish() {
                IWizardPage[] wpages;
                Map valueStore = WizardNode.this.template.getValueStore();
                this.finishPressed = true;
                this.getContainer().updateButtons();
                IWizardPage[] iWizardPageArray = wpages = this.getPages();
                int n = wpages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardPage page = iWizardPageArray[n2];
                    if (page instanceof UIWizardPage) {
                        valueStore.putAll(((UIWizardPage)page).getPageData());
                    }
                    ++n2;
                }
                WizardNode.this.template.getValueStore().putAll(WizardNode.this.parentPage.getDataInPreviousPages());
                return true;
            }

            public boolean canFinish() {
                return !this.finishPressed && super.canFinish();
            }

            public void createPageControls(Composite pageContainer) {
                IWizardPage[] wpages;
                super.createPageControls(pageContainer);
                WizardNode.this.parentPage.adjustTemplateValues(WizardNode.this.template);
                IWizardPage[] iWizardPageArray = wpages = this.getPages();
                int n = wpages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardPage page = iWizardPageArray[n2];
                    if (page instanceof UIWizardPage) {
                        ((UIWizardPage)page).getComposite().getUIElement().setValues(WizardNode.this.template.getValueStore());
                    }
                    ++n2;
                }
            }

            public Image getDefaultPageImage() {
                return WizardNode.this.parentPage.getImage();
            }
        };
        return this.wizard;
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }
}

