/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.job;

import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jgit.lib.Repository;

public class RepositoryRule
implements ISchedulingRule {
    private final Repository repo;

    private String getRepositoryPath() {
        return this.repo.getDirectory().getAbsolutePath();
    }

    private boolean isSameRepositoryRule(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof RepositoryRule) {
            RepositoryRule r = (RepositoryRule)rule;
            if (this.repo.getDirectory().getAbsolutePath().equals(r.getRepositoryPath())) {
                return true;
            }
        }
        return false;
    }

    public RepositoryRule(Repository repo) {
        this.repo = repo;
    }

    public boolean contains(ISchedulingRule rule) {
        return this.isSameRepositoryRule(rule);
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this.isSameRepositoryRule(rule);
    }
}

