/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.core;

import java.util.Map;
import org.eclipse.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.internal.autotools.core.AutotoolsProblemMarkerInfo;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;

public abstract class MarkerGenerator {
    static final int SEVERITY_INFO = 0;
    static final int SEVERITY_WARNING = 1;
    static final int SEVERITY_ERROR_RESOURCE = 2;
    static final int SEVERITY_ERROR_BUILD = 3;

    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        try {
            IMarker[] cur = file.findMarkers("org.eclipse.cdt.autotools.core.problem", false, 1);
            if (cur != null && cur.length > 0) {
                int i = 0;
                while (i < cur.length) {
                    int line = (Integer)cur[i].getAttribute("location");
                    int sev = (Integer)cur[i].getAttribute("severity");
                    String mesg = (String)cur[i].getAttribute("message");
                    if (line == lineNumber && sev == this.mapMarkerSeverity(severity) && mesg.equals(errorDesc)) {
                        return;
                    }
                    ++i;
                }
            }
            IMarker marker = file.createMarker("org.eclipse.cdt.autotools.core.problem");
            marker.setAttribute("location", lineNumber);
            marker.setAttribute("message", (Object)errorDesc);
            marker.setAttribute("severity", this.mapMarkerSeverity(severity));
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("charStart", -1);
            marker.setAttribute("charEnd", -1);
            if (errorVar != null) {
                marker.setAttribute("problem.variable", (Object)errorVar);
            }
        }
        catch (CoreException e) {
            AutotoolsPlugin.log(e.getStatus());
        }
    }

    public abstract IProject getProject();

    public boolean hasMarkers(IResource file) {
        IMarker[] markers;
        try {
            markers = file.findMarkers("org.eclipse.cdt.autotools.core.problem", false, 1);
        }
        catch (CoreException e) {
            return false;
        }
        return markers.length > 0;
    }

    public void addMarker(AutotoolsProblemMarkerInfo autotoolsMarker) {
        ProblemMarkerInfo info = autotoolsMarker.getMarker();
        try {
            Map attributes;
            IMarker[] cur;
            IResource markerResource = info.file;
            if (markerResource == null) {
                markerResource = this.getProject();
            }
            if ((cur = markerResource.findMarkers("org.eclipse.cdt.autotools.core.problem", true, 1)) != null && cur.length > 0) {
                int i = 0;
                while (i < cur.length) {
                    int line = (Integer)cur[i].getAttribute("location");
                    int sev = (Integer)cur[i].getAttribute("severity");
                    String mesg = (String)cur[i].getAttribute("message");
                    if (line == info.lineNumber && sev == this.mapMarkerSeverity(info.severity) && mesg.equals(info.description)) {
                        return;
                    }
                    ++i;
                }
            }
            IMarker marker = markerResource.createMarker("org.eclipse.cdt.autotools.core.problem");
            marker.setAttribute("location", info.lineNumber);
            marker.setAttribute("message", (Object)info.description);
            marker.setAttribute("severity", this.mapMarkerSeverity(info.severity));
            marker.setAttribute("lineNumber", info.lineNumber);
            marker.setAttribute("charStart", -1);
            marker.setAttribute("charEnd", -1);
            if (info.variableName != null) {
                marker.setAttribute("problem.variable", (Object)info.variableName);
            }
            if (info.externalPath != null) {
                marker.setAttribute("problem.externalLocation", (Object)info.externalPath.toOSString());
            }
            if ((attributes = info.getAttributes()) != null) {
                for (Map.Entry entry : attributes.entrySet()) {
                    marker.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
        }
        catch (CoreException e) {
            AutotoolsPlugin.log(e.getStatus());
        }
    }

    private int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    public void removeAllMarkers(IProject project) {
        IMarker[] markers;
        if (project == null || !project.isAccessible()) {
            return;
        }
        IWorkspace workspace = project.getWorkspace();
        try {
            markers = project.findMarkers("org.eclipse.cdt.autotools.core.problem", true, 2);
        }
        catch (CoreException e) {
            return;
        }
        if (markers != null) {
            try {
                workspace.deleteMarkers(markers);
            }
            catch (CoreException e) {
                return;
            }
        }
    }
}

