/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal;

import java.io.IOException;
import org.eclipse.dltk.dbgp.internal.DbgpTermination;
import org.eclipse.dltk.dbgp.internal.Messages;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;

public abstract class DbgpWorkingThread
extends DbgpTermination {
    private Thread thread;
    private final String name;

    public DbgpWorkingThread(String name) {
        this.name = name;
    }

    public void start() {
        if (this.thread != null && this.thread.isAlive()) {
            throw new IllegalStateException(Messages.DbgpWorkingThread_threadAlreadyStarted);
        }
        this.thread = new Thread(() -> {
            try {
                this.workingCycle();
            }
            catch (Exception e) {
                if (this.isLoggable(e)) {
                    DLTKDebugPlugin.logError(Messages.DbgpWorkingThread_workingCycleError, e);
                }
                this.fireObjectTerminated(e);
                return;
            }
            this.fireObjectTerminated(null);
        }, this.name);
        this.thread.start();
    }

    @Override
    public void requestTermination() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }

    @Override
    public void waitTerminated() throws InterruptedException {
        if (this.thread != null) {
            this.thread.join();
        }
    }

    protected boolean isLoggable(Exception e) {
        return !(e instanceof IOException);
    }

    protected abstract void workingCycle() throws Exception;
}

