/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.editor.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.php.composer.ui.editor.ComposerFormPage;
import org.eclipse.php.composer.ui.editor.ComposerSection;
import org.eclipse.php.composer.ui.editor.FormEntryAdapter;
import org.eclipse.php.composer.ui.editor.FormLayoutFactory;
import org.eclipse.php.composer.ui.editor.composer.Messages;
import org.eclipse.php.composer.ui.parts.BooleanFormEntry;
import org.eclipse.php.composer.ui.parts.FormEntry;
import org.eclipse.php.composer.ui.parts.IBooleanFormEntryListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ConfigSection
extends ComposerSection {
    protected FormEntry processTimeoutEntry;
    protected FormEntry vendorDirEntry;
    protected FormEntry binDirEntry;
    protected BooleanFormEntry notifyOnInstallEntry;

    public ConfigSection(ComposerFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(Messages.ConfigSection_Title);
        section.setDescription(Messages.ConfigSection_Description);
        section.setLayoutData((Object)new GridData(768));
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 2));
        section.setClient((Control)client);
        this.createProcessTimeoutEntry(client, toolkit);
        this.createVendorDirEntry(client, toolkit);
        this.createBinDirEntry(client, toolkit);
        this.createNotifyOnInstallEntry(client, toolkit);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.processTimeoutEntry.setEnabled(enabled);
        this.vendorDirEntry.setEnabled(enabled);
        this.binDirEntry.setEnabled(enabled);
        this.notifyOnInstallEntry.setEnabled(enabled);
    }

    private void createProcessTimeoutEntry(Composite client, FormToolkit toolkit) {
        this.processTimeoutEntry = new FormEntry(client, toolkit, "process-timeout", null, false);
        Integer processTimeout = this.composerPackage.getConfig().getProcessTimeout();
        if (processTimeout != null) {
            this.processTimeoutEntry.setValue(String.valueOf(processTimeout), true);
        }
        this.processTimeoutEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (entry.getValue().isEmpty()) {
                    ConfigSection.this.composerPackage.getConfig().remove("process-timeout");
                } else {
                    ConfigSection.this.composerPackage.getConfig().set("process-timeout", (Object)Integer.valueOf(entry.getValue()));
                }
            }
        });
        this.composerPackage.getConfig().addPropertyChangeListener("process-timeout", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Integer processTimeout = ConfigSection.this.composerPackage.getConfig().getProcessTimeout();
                if (processTimeout == null) {
                    ConfigSection.this.processTimeoutEntry.setValue("", true);
                } else {
                    ConfigSection.this.processTimeoutEntry.setValue(String.valueOf(processTimeout), true);
                }
            }
        });
    }

    private void createVendorDirEntry(Composite client, FormToolkit toolkit) {
        this.vendorDirEntry = new FormEntry(client, toolkit, "vendor-dir", null, false);
        String vendorDir = this.composerPackage.getConfig().getVendorDir();
        if (vendorDir != null) {
            this.vendorDirEntry.setValue(vendorDir, true);
        }
        this.vendorDirEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (entry.getValue().isEmpty()) {
                    ConfigSection.this.composerPackage.getConfig().remove("vendor-dir");
                } else {
                    ConfigSection.this.composerPackage.getConfig().set("vendor-dir", (Object)entry.getValue());
                }
            }
        });
        this.composerPackage.getConfig().addPropertyChangeListener("vendor-dir", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String vendorDir = ConfigSection.this.composerPackage.getConfig().getVendorDir();
                if (vendorDir != null) {
                    ConfigSection.this.vendorDirEntry.setValue("", true);
                } else {
                    ConfigSection.this.vendorDirEntry.setValue(ConfigSection.this.composerPackage.getConfig().getVendorDir(), true);
                }
            }
        });
    }

    private void createBinDirEntry(Composite client, FormToolkit toolkit) {
        this.binDirEntry = new FormEntry(client, toolkit, "bin-dir", null, false);
        String binDir = this.composerPackage.getConfig().getBinDir();
        if (binDir != null) {
            this.binDirEntry.setValue(binDir, true);
        }
        this.binDirEntry.addFormEntryListener(new FormEntryAdapter(){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (entry.getValue().isEmpty()) {
                    ConfigSection.this.composerPackage.getConfig().remove("bin-dir");
                } else {
                    ConfigSection.this.composerPackage.getConfig().set("bin-dir", (Object)entry.getValue());
                }
            }
        });
        this.composerPackage.getConfig().addPropertyChangeListener("bin-dir", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String binDir = ConfigSection.this.composerPackage.getConfig().getBinDir();
                if (binDir == null) {
                    ConfigSection.this.binDirEntry.setValue("", true);
                } else {
                    ConfigSection.this.binDirEntry.setValue(binDir, true);
                }
            }
        });
    }

    private void createNotifyOnInstallEntry(Composite client, FormToolkit toolkit) {
        this.notifyOnInstallEntry = new BooleanFormEntry(client, toolkit, "notify-on-install");
        this.notifyOnInstallEntry.setValue(this.composerPackage.getConfig().getNotifyOnInstall());
        this.notifyOnInstallEntry.addBooleanFormEntryListener(new IBooleanFormEntryListener(){

            @Override
            public void selectionChanged(BooleanFormEntry entry) {
                if (entry.getValue()) {
                    ConfigSection.this.composerPackage.getConfig().remove("notify-on-install");
                } else {
                    ConfigSection.this.composerPackage.getConfig().setNotifyOnInstall(entry.getValue());
                }
            }
        });
        this.composerPackage.getConfig().addPropertyChangeListener("notify-on-install", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ConfigSection.this.notifyOnInstallEntry.setValue(ConfigSection.this.composerPackage.getConfig().getNotifyOnInstall(), true);
            }
        });
    }
}

