/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.PropertyHookList;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.visitor.Visitor;

public class SingleFieldDeclaration
extends ASTNode {
    private Variable name;
    private Expression value;
    private PropertyHookList hooks;
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(SingleFieldDeclaration.class, "name", Variable.class, true, false);
    public static final ChildPropertyDescriptor VALUE_PROPERTY = new ChildPropertyDescriptor(SingleFieldDeclaration.class, "value", Expression.class, false, true);
    public static final ChildPropertyDescriptor HOOKS_PROPERTY = new ChildPropertyDescriptor(SingleFieldDeclaration.class, "hooks", PropertyHookList.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS84;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(2);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(VALUE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
        propertyList = new ArrayList(3);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(VALUE_PROPERTY);
        propertyList.add(HOOKS_PROPERTY);
        PROPERTY_DESCRIPTORS84 = Collections.unmodifiableList(propertyList);
    }

    public SingleFieldDeclaration(AST ast) {
        super(ast);
    }

    public SingleFieldDeclaration(int start, int end, AST ast, Variable name, Expression value, PropertyHookList hooks) {
        super(start, end, ast);
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.setName(name);
        if (value != null) {
            this.setValue(value);
        }
        if (hooks != null) {
            this.setHooks(hooks);
        }
    }

    public SingleFieldDeclaration(int start, int end, AST ast, Variable name, Expression value) {
        this(start, end, ast, name, value, null);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.name.accept(visitor);
        if (this.value != null) {
            this.value.accept(visitor);
        }
        if (this.hooks != null) {
            this.hooks.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.name.accept(visitor);
        if (this.value != null) {
            this.value.traverseTopDown(visitor);
        }
        if (this.hooks != null) {
            this.hooks.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.name.accept(visitor);
        if (this.value != null) {
            this.value.traverseBottomUp(visitor);
        }
        if (this.hooks != null) {
            this.hooks.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<SingleFieldDeclaration");
        this.appendInterval(buffer);
        buffer.append("'>\n").append(tab).append("\t").append("<VariableName>\n");
        this.name.toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("\t").append("</VariableName>\n");
        buffer.append(tab).append("\t").append("<InitialValue>\n");
        if (this.value != null) {
            this.value.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("\t").append("</InitialValue>\n");
        this.hooks.toString(buffer, "\t" + tab);
        buffer.append(tab).append("</SingleFieldDeclaration>");
    }

    @Override
    public int getType() {
        return 63;
    }

    public Variable getName() {
        return this.name;
    }

    public void setName(Variable name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Variable oldChild = this.name;
        this.preReplaceChild(oldChild, name, NAME_PROPERTY);
        this.name = name;
        this.postReplaceChild(oldChild, name, NAME_PROPERTY);
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        Expression oldChild = this.value;
        this.preReplaceChild(oldChild, value, VALUE_PROPERTY);
        this.value = value;
        this.postReplaceChild(oldChild, value, VALUE_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((Variable)child);
            return null;
        }
        if (property == VALUE_PROPERTY) {
            if (get) {
                return this.getValue();
            }
            this.setValue((Expression)child);
            return null;
        }
        if (property == HOOKS_PROPERTY) {
            if (get) {
                return this.getHooks();
            }
            this.setHooks((PropertyHookList)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Variable name = ASTNode.copySubtree(target, this.getName());
        Expression value = ASTNode.copySubtree(target, this.getValue());
        PropertyHookList hooks = ASTNode.copySubtree(target, this.getHooks());
        SingleFieldDeclaration result = new SingleFieldDeclaration(this.getStart(), this.getEnd(), target, name, value, hooks);
        return result;
    }

    public PropertyHookList getHooks() {
        return this.hooks;
    }

    public void setHooks(PropertyHookList hooks) {
        PropertyHookList oldChild = this.hooks;
        this.preReplaceChild(oldChild, hooks, HOOKS_PROPERTY);
        this.hooks = hooks;
        this.postReplaceChild(oldChild, hooks, HOOKS_PROPERTY);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        if (PHPVersion.PHP8_4.isGreaterThan(apiLevel)) {
            return PROPERTY_DESCRIPTORS;
        }
        return PROPERTY_DESCRIPTORS84;
    }

    public IVariableBinding resolveVariableBinding() {
        return this.ast.getBindingResolver().getVariableBinding(this);
    }
}

