/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parsers.jruby;

import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.ruby.internal.parsers.jruby.IDLTKRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SourcePosition;

public class DLTKRubyWarnings
implements IDLTKRubyWarnings {
    private final IProblemReporter problemReporter;

    public DLTKRubyWarnings(IProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    @Override
    public void warn(ISourcePosition position, String message) {
        DefaultProblem problem = new DefaultProblem(position.getFile(), message, 0, new String[0], ProblemSeverities.Warning, position.getStartOffset(), position.getEndOffset(), position.getStartLine());
        this.problemReporter.reportProblem((IProblem)problem);
    }

    @Override
    public boolean isVerbose() {
        return false;
    }

    @Override
    public void warning(ISourcePosition position, String message) {
        if (this.isVerbose()) {
            DefaultProblem problem = new DefaultProblem(position.getFile(), message, 0, new String[0], ProblemSeverities.Warning, position.getStartOffset(), position.getEndOffset(), position.getStartLine());
            this.problemReporter.reportProblem((IProblem)problem);
        }
    }

    @Override
    public void error(ISourcePosition position, String message) {
        DefaultProblem problem = new DefaultProblem(position.getFile(), message, 0, new String[0], ProblemSeverities.Error, position.getStartOffset(), position.getEndOffset(), position.getStartLine());
        this.problemReporter.reportProblem((IProblem)problem);
    }

    @Override
    public void warn(String message) {
        this.warn(new SourcePosition(), message);
    }

    @Override
    public void warning(String message) {
        this.warning(new SourcePosition(), message);
    }
}

