/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.python.internal.core.codeassist.PythonASTUtil;

public abstract class PythonAssistParser
implements IAssistParser {
    protected ISourceParser parser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.python.core.nature");
    protected ModuleDeclaration module;
    protected ASTNode assistNodeParent = null;

    protected PythonAssistParser() {
    }

    public ASTNode getAssistNodeParent() {
        return this.assistNodeParent;
    }

    protected void findElementsTo(List statements, ASTNode node, List elements) {
        if (statements == null) {
            return;
        }
        Iterator i = statements.iterator();
        while (i.hasNext()) {
            ASTNode n = (ASTNode)i.next();
            if (n.equals(node)) {
                elements.add(n);
                return;
            }
            if (n.sourceStart() > node.sourceStart() || node.sourceEnd() > n.sourceEnd()) continue;
            elements.add(n);
            this.findElementsTo(PythonASTUtil.getStatements((ASTNode)n), node, elements);
            return;
        }
    }

    protected List findLevelsTo(ASTNode astNodeParent) {
        ArrayList<ModuleDeclaration> elements = new ArrayList<ModuleDeclaration>();
        if (this.module != null || astNodeParent instanceof ModuleDeclaration) {
            if (this.module == null) {
                this.module = (ModuleDeclaration)astNodeParent;
            }
            elements.add(this.module);
            this.findElementsTo(PythonASTUtil.getStatements((ASTNode)this.module), astNodeParent, elements);
        }
        return elements;
    }

    public void setSource(ModuleDeclaration unit) {
        this.module = unit;
    }

    public ModuleDeclaration parse(IModuleSource sourceUnit) {
        ModuleDeclaration module = (ModuleDeclaration)this.parser.parse(sourceUnit, null);
        module.rebuild();
        PythonASTUtil.extendStatements((ASTNode)module, sourceUnit.getSourceContents());
        return module;
    }
}

