/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.evaluation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.ExpressionList;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModule;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.python.internal.core.evaluation.PythonASTFindVisitor;
import org.eclipse.dltk.python.internal.core.evaluation.PythonASTLevelVisitor;
import org.eclipse.dltk.python.parser.ast.expressions.Assignment;
import org.eclipse.dltk.python.parser.ast.expressions.CallHolder;
import org.eclipse.dltk.python.parser.ast.expressions.ExtendedVariableReference;
import org.eclipse.dltk.python.parser.ast.statements.IfStatement;
import org.eclipse.dltk.python.parser.ast.statements.SwitchStatement;
import org.eclipse.dltk.python.parser.ast.statements.TryStatement;
import org.eclipse.dltk.python.parser.ast.statements.WhileStatement;

public class PythonTypeEvaluatorUtils {
    public static List getAllASTLevelChilds(ASTNode parent) {
        PythonASTLevelVisitor visitor = new PythonASTLevelVisitor();
        List nodes = new ArrayList(1);
        try {
            parent.traverse((ASTVisitor)visitor);
            nodes = visitor.getNodes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodes;
    }

    public static String makeASTNodeName(Map parents, ASTNode node) {
        String name = null;
        ASTNode nde = node;
        while (nde != null) {
            if (nde instanceof SimpleReference) {
                name = name != null ? String.valueOf(((SimpleReference)nde).getName()) + "." + name : ((SimpleReference)nde).getName();
            } else if (nde instanceof ExtendedVariableReference) {
                name = name != null ? String.valueOf(((ExtendedVariableReference)nde).getStringRepresentation()) + "." + name : ((ExtendedVariableReference)nde).getStringRepresentation();
            } else if (nde instanceof MethodDeclaration) {
                name = name != null ? String.valueOf(((MethodDeclaration)nde).getName()) + "." + name : ((MethodDeclaration)nde).getName();
            } else if (nde instanceof TypeDeclaration) {
                name = name != null ? String.valueOf(((TypeDeclaration)nde).getName()) + "." + name : ((TypeDeclaration)nde).getName();
            }
            if (!parents.containsKey(nde)) break;
            nde = (ASTNode)parents.get(nde);
        }
        return name;
    }

    public static String makePathByModule(IModule module) {
        String name = module.getElementName();
        IModelElement element = module.getParent();
        while (element != null && element.getElementType() != 1) {
            if (element.getElementType() == 3) {
                name = String.valueOf(element.getElementName()) + name;
            }
            if (element.getElementType() == 4) {
                name = String.valueOf(element.getElementName()) + "/" + name;
            }
            element = element.getParent();
        }
        return name;
    }

    public static ModuleDeclaration parseModuleForElement(IModelElement modelElement) throws Exception {
        IModule module = PythonTypeEvaluatorUtils.getElementModule(modelElement);
        if (module == null) {
            return null;
        }
        ISourceModule sourceUnit = (ISourceModule)module;
        return SourceParserUtil.getModuleDeclaration((ISourceModule)sourceUnit, null);
    }

    public static List parseCallHolder(CallHolder callHolder) {
        ArrayList arguments = new ArrayList();
        Expression refArgumentsList = callHolder.getArguments();
        if (refArgumentsList instanceof ExpressionList) {
            ExpressionList list = (ExpressionList)refArgumentsList;
            List refArguments = list.getExpressions();
            return refArguments;
        }
        return arguments;
    }

    public static IModule getElementModule(IModelElement element) {
        if (element == null) {
            return null;
        }
        if (element.getElementType() == 1) {
            return null;
        }
        if (element.getElementType() == 5) {
            IModule module = (IModule)element;
            return module;
        }
        IModelElement parent = element.getParent();
        if (parent != null) {
            return PythonTypeEvaluatorUtils.getElementModule(parent);
        }
        return null;
    }

    public static ASTNode getModelLikeNode(Map parents, ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Assignment) {
            ASTNode lnode = node;
            while (!(lnode instanceof TypeDeclaration) && !(lnode instanceof ModuleDeclaration)) {
                if (parents.containsKey(lnode)) {
                    lnode = (ASTNode)parents.get(lnode);
                    continue;
                }
                throw new RuntimeException("node not in AST.");
            }
            return lnode;
        }
        ASTNode lnode = node;
        while (!(lnode instanceof MethodDeclaration || lnode instanceof TypeDeclaration || lnode instanceof ModuleDeclaration)) {
            if (parents.containsKey(lnode)) {
                lnode = (ASTNode)parents.get(lnode);
                continue;
            }
            throw new RuntimeException("node not in AST.");
        }
        return lnode;
    }

    public static ASTNode getParentNode(Map parents, ASTNode node) {
        if (node == null) {
            return null;
        }
        ASTNode lnode = node;
        while (!(lnode instanceof MethodDeclaration || lnode instanceof TypeDeclaration || lnode instanceof ModuleDeclaration || lnode instanceof Block || lnode instanceof IfStatement || lnode instanceof WhileStatement || lnode instanceof SwitchStatement || lnode instanceof TryStatement)) {
            if (parents.containsKey(lnode)) {
                lnode = (ASTNode)parents.get(lnode);
                continue;
            }
            return null;
        }
        return lnode;
    }

    public static ASTNode getNodeParentBeforeModel(Map parents, ASTNode node) {
        ASTNode nodeParent;
        block2: {
            nodeParent = node;
            while (parents.containsKey(nodeParent)) {
                ASTNode mparent = (ASTNode)parents.get(nodeParent);
                if (!(mparent == null || mparent instanceof ModuleDeclaration || mparent instanceof MethodDeclaration || mparent instanceof TypeDeclaration || mparent instanceof Block || mparent instanceof IfStatement || mparent instanceof WhileStatement || mparent instanceof SwitchStatement || mparent instanceof TryStatement)) {
                    nodeParent = mparent;
                    continue;
                }
                break block2;
            }
            return null;
        }
        return nodeParent;
    }

    public static String findElementPath(IModelElement element) {
        IModule module = PythonTypeEvaluatorUtils.getElementModule(element);
        if (module != null) {
            return PythonTypeEvaluatorUtils.makePathByModule(module);
        }
        return null;
    }

    public static PythonASTFindVisitor findElementsByModelElement(ModuleDeclaration module, IModelElement modelElement) {
        String name = modelElement.getElementName();
        PythonASTFindVisitor visitor = new PythonASTFindVisitor(name);
        try {
            module.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return visitor;
    }
}

