/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model.impl;

import java.util.Collection;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelPackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionTypeImpl
extends MinimalEObjectImpl
implements FunctionType {
    protected JSType returnType;
    protected EList<Parameter> parameters;

    protected FunctionTypeImpl() {
    }

    protected EClass eStaticClass() {
        return TypeInfoModelPackage.Literals.FUNCTION_TYPE;
    }

    @Override
    public JSType getReturnType() {
        return this.returnType;
    }

    public NotificationChain basicSetReturnType(JSType newReturnType, NotificationChain msgs) {
        JSType oldReturnType = this.returnType;
        this.returnType = newReturnType;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldReturnType, (Object)newReturnType);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setReturnType(JSType newReturnType) {
        if (newReturnType != this.returnType) {
            NotificationChain msgs = null;
            if (this.returnType != null) {
                msgs = ((InternalEObject)this.returnType).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newReturnType != null) {
                msgs = ((InternalEObject)newReturnType).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetReturnType(newReturnType, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newReturnType, (Object)newReturnType));
        }
    }

    @Override
    public EList<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new EObjectContainmentEList(Parameter.class, (InternalEObject)this, 1);
        }
        return this.parameters;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append("function");
        this.printParameters(sb);
        if (this.returnType != null) {
            sb.append(":");
            sb.append(this.returnType.getName());
        }
        return sb.toString();
    }

    @Override
    public IRType toRType(ITypeSystem typeSystem) {
        return RTypes.functionType(typeSystem, RModelBuilder.convert(typeSystem, this.getParameters()), RTypes.create(typeSystem, this.getReturnType()));
    }

    protected void printParameters(StringBuilder sb) {
        sb.append("(");
        if (this.parameters != null) {
            boolean first = true;
            for (Parameter parameter : this.parameters) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                if (parameter.getName() != null) {
                    sb.append(parameter.getName());
                    sb.append(":");
                }
                sb.append(parameter.getType() != null ? parameter.getType().getName() : "*");
            }
        }
        sb.append(")");
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetReturnType(null, msgs);
            }
            case 1: {
                return ((InternalEList)this.getParameters()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getReturnType();
            }
            case 1: {
                return this.getParameters();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setReturnType((JSType)newValue);
                return;
            }
            case 1: {
                this.getParameters().clear();
                this.getParameters().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setReturnType(null);
                return;
            }
            case 1: {
                this.getParameters().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.returnType != null;
            }
            case 1: {
                return this.parameters != null && !this.parameters.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

