/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Method;

public class SetMethod
extends Method {
    private Keyword setKeyword;
    private Identifier argument;

    public SetMethod(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.setKeyword != null) {
                this.setKeyword.traverse(visitor);
            }
            if (this.getName() != null) {
                this.getName().traverse(visitor);
            }
            if (this.argument != null) {
                this.argument.traverse(visitor);
            }
            if (this.getBody() != null) {
                this.getBody().traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Identifier getArgument() {
        return this.argument;
    }

    public void setArgument(Identifier argument) {
        this.argument = argument;
    }

    public Keyword getSetKeyword() {
        return this.setKeyword;
    }

    public void setSetKeyword(Keyword keyword) {
        this.setKeyword = keyword;
    }

    public String toSourceString(String indentationString) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("set");
        buffer.append(" ");
        buffer.append(SetMethod.toSourceString(this.getName(), indentationString));
        buffer.append(" (");
        buffer.append(SetMethod.toSourceString(this.argument, indentationString));
        buffer.append(")\n");
        buffer.append(SetMethod.toSourceString(this.getBody(), indentationString));
        return buffer.toString();
    }
}

