/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.keyword.IKeywordCategory;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.javascript.core.JSKeywordCategory;
import org.eclipse.dltk.javascript.core.JSKeywordManager;
import org.eclipse.dltk.javascript.internal.ui.text.JavaScriptScriptCommentScanner;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.TodoTaskPreferencesOnPreferenceStore;
import org.eclipse.dltk.ui.text.rules.CombinedWordRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptDocScanner
extends JavaScriptScriptCommentScanner {
    public JavascriptDocScanner(ScriptSourceViewerConfiguration configuration) {
        super(configuration, "JS_DOC", "DLTK_comment_task_tag", (ITodoTaskPreferences)new TodoTaskPreferencesOnPreferenceStore(configuration.getPreferenceStore()));
    }

    protected String[] getTokenProperties() {
        return new String[]{"JS_DOC", "DLTK_comment_task_tag", "JS_DOC_TAGS"};
    }

    protected List<CombinedWordRule.WordMatcher> createMatchers() {
        List matchers = super.createMatchers();
        matchers.add(this.createJavadocKeywordMatcher());
        return matchers;
    }

    private CombinedWordRule.WordMatcher createJavadocKeywordMatcher() {
        ITextEditor editor;
        CombinedWordRule.WordMatcher matcher = new CombinedWordRule.WordMatcher();
        HashSet tags = new HashSet();
        Collections.addAll(tags, JSDocTag.getTags());
        ISourceModule module = null;
        if (this.fConfiguration != null && (editor = this.fConfiguration.getEditor()) != null) {
            module = EditorUtility.getEditorInputModelElement((IEditorPart)editor, (boolean)true);
        }
        Collections.addAll(tags, JSKeywordManager.getInstance().getKeywords((IKeywordCategory)JSKeywordCategory.JS_DOC_TAG, module));
        for (String tag : tags) {
            matcher.addWord(tag, (IToken)this.getToken("JS_DOC_TAGS"));
        }
        return matcher;
    }

    protected IWordDetector createIdentifierDetector() {
        return new IWordDetector(){

            public boolean isWordStart(char c) {
                return c == '@' || Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return c == '.' || c == '-' || Character.isJavaIdentifierPart(c);
            }
        };
    }
}

