/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class ThrowStatement
extends Statement
implements ISemicolonStatement {
    private Keyword throwKeyword;
    private Expression exception;
    private int semic = -1;

    public ThrowStatement(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.throwKeyword != null) {
                this.throwKeyword.traverse(visitor);
            }
            if (this.exception != null) {
                this.exception.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getException() {
        return this.exception;
    }

    public void setException(Expression exception) {
        this.exception = exception;
    }

    public Keyword getThrowKeyword() {
        return this.throwKeyword;
    }

    public void setThrowKeyword(Keyword keyword) {
        this.throwKeyword = keyword;
    }

    public int getSemicolonPosition() {
        return this.semic;
    }

    public void setSemicolonPosition(int semic) {
        this.semic = semic;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("throw");
        if (this.exception != null) {
            buffer.append(' ');
            buffer.append(this.exception.toSourceString(indentationString));
        }
        if (this.semic > 0) {
            buffer.append(";\n");
        }
        return buffer.toString();
    }
}

