/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IValidationStatus;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.PhantomValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IRLocalType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RLocalType
extends RType
implements IRLocalType {
    private final IValueReference functionValue;
    private final String name;

    RLocalType(String name, IValueReference functionValue) {
        this.name = name;
        this.functionValue = functionValue;
    }

    @Override
    public IValueReference getValue() {
        IValueCollection value = (IValueCollection)this.functionValue.getAttribute("FUNCTION_SCOPE", false);
        if (value != null) {
            return value.getThis();
        }
        return PhantomValueReference.REFERENCE;
    }

    @Override
    public IValueReference getDirectChild(String name) {
        IValueReference value = this.getValue();
        if (value.getDirectChildren(2).contains(name)) {
            return value.getChild(name);
        }
        JSTypeSet declaredTypes = this.getValue().getDeclaredTypes();
        HashSet<IRType> set = new HashSet<IRType>();
        set.add(this);
        return this.getChildFromDeclaredTypes(name, declaredTypes, set);
    }

    private IValueReference getChildFromDeclaredTypes(String name, JSTypeSet declaredTypes, HashSet<IRType> set) {
        for (IRType irType : declaredTypes) {
            if (!(irType instanceof RLocalType) || !set.add(irType)) continue;
            IValueReference declaredValue = ((RLocalType)irType).getValue();
            if (declaredValue.getDirectChildren(2).contains(name)) {
                return declaredValue.getChild(name);
            }
            IValueReference fromChild = this.getChildFromDeclaredTypes(name, declaredValue.getDeclaredTypes(), set);
            if (fromChild == null) continue;
            return fromChild;
        }
        return null;
    }

    @Override
    public Set<String> getDirectChildren() {
        Set<String> children = this.getValue().getDirectChildren(2);
        JSTypeSet declaredTypes = this.getValue().getDeclaredTypes();
        HashSet<IRType> set = new HashSet<IRType>();
        set.add(this);
        this.fillDeclaredLocalTypesChildren(children, declaredTypes, set);
        return children;
    }

    private void fillDeclaredLocalTypesChildren(Set<String> children, JSTypeSet declaredTypes, HashSet<IRType> set) {
        for (IRType irType : declaredTypes) {
            if (!(irType instanceof RLocalType) || !set.add(irType)) continue;
            children.addAll(((RLocalType)irType).getValue().getDirectChildren(2));
            this.fillDeclaredLocalTypesChildren(children, ((RLocalType)irType).getValue().getDeclaredTypes(), set);
        }
    }

    @Override
    public ReferenceLocation getReferenceLocation() {
        return this.functionValue.getLocation();
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        if (type instanceof IRLocalType ? this.getReferenceLocation().equals(((IRLocalType)type).getReferenceLocation()) : type instanceof IRSimpleType && ((IRSimpleType)type).getTarget().getKind() == TypeKind.UNKNOWN && type.getName().equals(this.getName())) {
            return TypeCompatibility.TRUE;
        }
        return super.isAssignableFrom(type);
    }

    @Override
    public IValidationStatus isAssignableFrom(IValueReference argument) {
        if (argument == null) {
            return TypeCompatibility.TRUE;
        }
        Set<IRType> types = JavaScriptValidations.getTypes(argument);
        return this.testLocation(types, new HashSet<IRType>());
    }

    private IValidationStatus testLocation(Iterable<IRType> types, HashSet<IRType> set) {
        for (IRType irType : types) {
            if (!(irType instanceof IRLocalType) || !set.add(irType)) continue;
            if (this.getReferenceLocation().equals(((IRLocalType)irType).getReferenceLocation())) {
                return TypeCompatibility.TRUE;
            }
            IValidationStatus status = this.testLocation(((IRLocalType)irType).getValue().getDeclaredTypes(), set);
            if (status != TypeCompatibility.TRUE) continue;
            return status;
        }
        return TypeCompatibility.FALSE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RLocalType) {
            return this.getReferenceLocation().equals(((RLocalType)obj).getReferenceLocation());
        }
        return false;
    }
}

